<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FlightInfo StructType
 * @subpackage Structs
 */
class JP_FlightInfo extends AbstractStructBase
{
    /**
     * The FlightTime
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $FlightTime;
    /**
     * The Airport
     * @var string
     */
    public $Airport;
    /**
     * The FlightNumber
     * @var string
     */
    public $FlightNumber;
    /**
     * Constructor method for JP_FlightInfo
     * @uses JP_FlightInfo::setFlightTime()
     * @uses JP_FlightInfo::setAirport()
     * @uses JP_FlightInfo::setFlightNumber()
     * @param string $flightTime
     * @param string $airport
     * @param string $flightNumber
     */
    public function __construct($flightTime = null, $airport = null, $flightNumber = null)
    {
        $this
            ->setFlightTime($flightTime)
            ->setAirport($airport)
            ->setFlightNumber($flightNumber);
    }
    /**
     * Get FlightTime value
     * @return string
     */
    public function getFlightTime()
    {
        return $this->FlightTime;
    }
    /**
     * Set FlightTime value
     * @param string $flightTime
     * @return \StructType\JP_FlightInfo
     */
    public function setFlightTime($flightTime = null)
    {
        // validation for constraint: string
        if (!is_null($flightTime) && !is_string($flightTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightTime, true), gettype($flightTime)), __LINE__);
        }
        $this->FlightTime = $flightTime;
        return $this;
    }
    /**
     * Get Airport value
     * @return string|null
     */
    public function getAirport()
    {
        return $this->Airport;
    }
    /**
     * Set Airport value
     * @param string $airport
     * @return \StructType\JP_FlightInfo
     */
    public function setAirport($airport = null)
    {
        // validation for constraint: string
        if (!is_null($airport) && !is_string($airport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airport, true), gettype($airport)), __LINE__);
        }
        $this->Airport = $airport;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\JP_FlightInfo
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FlightInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
