<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Day StructType
 * @subpackage Structs
 */
class JP_Day extends AbstractStructBase
{
    /**
     * The Harbor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Harbor
     */
    public $Harbor;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The DepartureTime
     * @var string
     */
    public $DepartureTime;
    /**
     * The ArrivalTime
     * @var string
     */
    public $ArrivalTime;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The OnSea
     * @var bool
     */
    public $OnSea;
    /**
     * Constructor method for JP_Day
     * @uses JP_Day::setHarbor()
     * @uses JP_Day::setCode()
     * @uses JP_Day::setDepartureTime()
     * @uses JP_Day::setArrivalTime()
     * @uses JP_Day::setOrder()
     * @uses JP_Day::setOnSea()
     * @param \StructType\JP_Harbor $harbor
     * @param string $code
     * @param string $departureTime
     * @param string $arrivalTime
     * @param int $order
     * @param bool $onSea
     */
    public function __construct(\StructType\JP_Harbor $harbor = null, $code = null, $departureTime = null, $arrivalTime = null, $order = null, $onSea = null)
    {
        $this
            ->setHarbor($harbor)
            ->setCode($code)
            ->setDepartureTime($departureTime)
            ->setArrivalTime($arrivalTime)
            ->setOrder($order)
            ->setOnSea($onSea);
    }
    /**
     * Get Harbor value
     * @return \StructType\JP_Harbor|null
     */
    public function getHarbor()
    {
        return $this->Harbor;
    }
    /**
     * Set Harbor value
     * @param \StructType\JP_Harbor $harbor
     * @return \StructType\JP_Day
     */
    public function setHarbor(\StructType\JP_Harbor $harbor = null)
    {
        $this->Harbor = $harbor;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_Day
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \StructType\JP_Day
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureTime, true), gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get ArrivalTime value
     * @return string|null
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \StructType\JP_Day
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalTime, true), gettype($arrivalTime)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_Day
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get OnSea value
     * @return bool|null
     */
    public function getOnSea()
    {
        return $this->OnSea;
    }
    /**
     * Set OnSea value
     * @param bool $onSea
     * @return \StructType\JP_Day
     */
    public function setOnSea($onSea = null)
    {
        // validation for constraint: boolean
        if (!is_null($onSea) && !is_bool($onSea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onSea, true), gettype($onSea)), __LINE__);
        }
        $this->OnSea = $onSea;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Day
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
