<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_AgencyData StructType
 * @subpackage Structs
 */
class JP_AgencyData extends AbstractStructBase
{
    /**
     * The ReferencedAgency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ReferencedAgency;
    /**
     * The AgencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AgencyCode;
    /**
     * The AgencyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyName;
    /**
     * The AgencyHandledBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyHandledBy;
    /**
     * The AgencyEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyEmail;
    /**
     * The AgencyCommercialPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyCommercialPhone;
    /**
     * The AgencyReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyReference;
    /**
     * The AgencyFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyFile;
    /**
     * The SecurityKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecurityKey;
    /**
     * Constructor method for JP_AgencyData
     * @uses JP_AgencyData::setReferencedAgency()
     * @uses JP_AgencyData::setAgencyCode()
     * @uses JP_AgencyData::setAgencyName()
     * @uses JP_AgencyData::setAgencyHandledBy()
     * @uses JP_AgencyData::setAgencyEmail()
     * @uses JP_AgencyData::setAgencyCommercialPhone()
     * @uses JP_AgencyData::setAgencyReference()
     * @uses JP_AgencyData::setAgencyFile()
     * @uses JP_AgencyData::setSecurityKey()
     * @param bool $referencedAgency
     * @param int $agencyCode
     * @param string $agencyName
     * @param string $agencyHandledBy
     * @param string $agencyEmail
     * @param string $agencyCommercialPhone
     * @param string $agencyReference
     * @param string $agencyFile
     * @param string $securityKey
     */
    public function __construct($referencedAgency = null, $agencyCode = null, $agencyName = null, $agencyHandledBy = null, $agencyEmail = null, $agencyCommercialPhone = null, $agencyReference = null, $agencyFile = null, $securityKey = null)
    {
        $this
            ->setReferencedAgency($referencedAgency)
            ->setAgencyCode($agencyCode)
            ->setAgencyName($agencyName)
            ->setAgencyHandledBy($agencyHandledBy)
            ->setAgencyEmail($agencyEmail)
            ->setAgencyCommercialPhone($agencyCommercialPhone)
            ->setAgencyReference($agencyReference)
            ->setAgencyFile($agencyFile)
            ->setSecurityKey($securityKey);
    }
    /**
     * Get ReferencedAgency value
     * @return bool
     */
    public function getReferencedAgency()
    {
        return $this->ReferencedAgency;
    }
    /**
     * Set ReferencedAgency value
     * @param bool $referencedAgency
     * @return \StructType\JP_AgencyData
     */
    public function setReferencedAgency($referencedAgency = null)
    {
        // validation for constraint: boolean
        if (!is_null($referencedAgency) && !is_bool($referencedAgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($referencedAgency, true), gettype($referencedAgency)), __LINE__);
        }
        $this->ReferencedAgency = $referencedAgency;
        return $this;
    }
    /**
     * Get AgencyCode value
     * @return int
     */
    public function getAgencyCode()
    {
        return $this->AgencyCode;
    }
    /**
     * Set AgencyCode value
     * @param int $agencyCode
     * @return \StructType\JP_AgencyData
     */
    public function setAgencyCode($agencyCode = null)
    {
        // validation for constraint: int
        if (!is_null($agencyCode) && !(is_int($agencyCode) || ctype_digit($agencyCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agencyCode, true), gettype($agencyCode)), __LINE__);
        }
        $this->AgencyCode = $agencyCode;
        return $this;
    }
    /**
     * Get AgencyName value
     * @return string|null
     */
    public function getAgencyName()
    {
        return $this->AgencyName;
    }
    /**
     * Set AgencyName value
     * @param string $agencyName
     * @return \StructType\JP_AgencyData
     */
    public function setAgencyName($agencyName = null)
    {
        // validation for constraint: string
        if (!is_null($agencyName) && !is_string($agencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyName, true), gettype($agencyName)), __LINE__);
        }
        $this->AgencyName = $agencyName;
        return $this;
    }
    /**
     * Get AgencyHandledBy value
     * @return string|null
     */
    public function getAgencyHandledBy()
    {
        return $this->AgencyHandledBy;
    }
    /**
     * Set AgencyHandledBy value
     * @param string $agencyHandledBy
     * @return \StructType\JP_AgencyData
     */
    public function setAgencyHandledBy($agencyHandledBy = null)
    {
        // validation for constraint: string
        if (!is_null($agencyHandledBy) && !is_string($agencyHandledBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyHandledBy, true), gettype($agencyHandledBy)), __LINE__);
        }
        $this->AgencyHandledBy = $agencyHandledBy;
        return $this;
    }
    /**
     * Get AgencyEmail value
     * @return string|null
     */
    public function getAgencyEmail()
    {
        return $this->AgencyEmail;
    }
    /**
     * Set AgencyEmail value
     * @param string $agencyEmail
     * @return \StructType\JP_AgencyData
     */
    public function setAgencyEmail($agencyEmail = null)
    {
        // validation for constraint: string
        if (!is_null($agencyEmail) && !is_string($agencyEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyEmail, true), gettype($agencyEmail)), __LINE__);
        }
        $this->AgencyEmail = $agencyEmail;
        return $this;
    }
    /**
     * Get AgencyCommercialPhone value
     * @return string|null
     */
    public function getAgencyCommercialPhone()
    {
        return $this->AgencyCommercialPhone;
    }
    /**
     * Set AgencyCommercialPhone value
     * @param string $agencyCommercialPhone
     * @return \StructType\JP_AgencyData
     */
    public function setAgencyCommercialPhone($agencyCommercialPhone = null)
    {
        // validation for constraint: string
        if (!is_null($agencyCommercialPhone) && !is_string($agencyCommercialPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyCommercialPhone, true), gettype($agencyCommercialPhone)), __LINE__);
        }
        $this->AgencyCommercialPhone = $agencyCommercialPhone;
        return $this;
    }
    /**
     * Get AgencyReference value
     * @return string|null
     */
    public function getAgencyReference()
    {
        return $this->AgencyReference;
    }
    /**
     * Set AgencyReference value
     * @param string $agencyReference
     * @return \StructType\JP_AgencyData
     */
    public function setAgencyReference($agencyReference = null)
    {
        // validation for constraint: string
        if (!is_null($agencyReference) && !is_string($agencyReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyReference, true), gettype($agencyReference)), __LINE__);
        }
        $this->AgencyReference = $agencyReference;
        return $this;
    }
    /**
     * Get AgencyFile value
     * @return string|null
     */
    public function getAgencyFile()
    {
        return $this->AgencyFile;
    }
    /**
     * Set AgencyFile value
     * @param string $agencyFile
     * @return \StructType\JP_AgencyData
     */
    public function setAgencyFile($agencyFile = null)
    {
        // validation for constraint: string
        if (!is_null($agencyFile) && !is_string($agencyFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyFile, true), gettype($agencyFile)), __LINE__);
        }
        $this->AgencyFile = $agencyFile;
        return $this;
    }
    /**
     * Get SecurityKey value
     * @return string|null
     */
    public function getSecurityKey()
    {
        return $this->SecurityKey;
    }
    /**
     * Set SecurityKey value
     * @param string $securityKey
     * @return \StructType\JP_AgencyData
     */
    public function setSecurityKey($securityKey = null)
    {
        // validation for constraint: string
        if (!is_null($securityKey) && !is_string($securityKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityKey, true), gettype($securityKey)), __LINE__);
        }
        $this->SecurityKey = $securityKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_AgencyData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
