<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_HotelAvailReleases StructType
 * @subpackage Structs
 */
class JPSOAP_HotelAvailReleases extends AbstractStructBase
{
    /**
     * The Release
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_HotelAvailRelease[]
     */
    public $Release;
    /**
     * The Time
     * @var string
     */
    public $Time;
    /**
     * The TimeZone
     * @var string
     */
    public $TimeZone;
    /**
     * Constructor method for JPSOAP_HotelAvailReleases
     * @uses JPSOAP_HotelAvailReleases::setRelease()
     * @uses JPSOAP_HotelAvailReleases::setTime()
     * @uses JPSOAP_HotelAvailReleases::setTimeZone()
     * @param \StructType\JPSOAP_HotelAvailRelease[] $release
     * @param string $time
     * @param string $timeZone
     */
    public function __construct(array $release = array(), $time = null, $timeZone = null)
    {
        $this
            ->setRelease($release)
            ->setTime($time)
            ->setTimeZone($timeZone);
    }
    /**
     * Get Release value
     * @return \StructType\JPSOAP_HotelAvailRelease[]|null
     */
    public function getRelease()
    {
        return $this->Release;
    }
    /**
     * This method is responsible for validating the values passed to the setRelease method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelease method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReleaseForArrayConstraintsFromSetRelease(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jPSOAP_HotelAvailReleasesReleaseItem) {
            // validation for constraint: itemType
            if (!$jPSOAP_HotelAvailReleasesReleaseItem instanceof \StructType\JPSOAP_HotelAvailRelease) {
                $invalidValues[] = is_object($jPSOAP_HotelAvailReleasesReleaseItem) ? get_class($jPSOAP_HotelAvailReleasesReleaseItem) : sprintf('%s(%s)', gettype($jPSOAP_HotelAvailReleasesReleaseItem), var_export($jPSOAP_HotelAvailReleasesReleaseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Release property can only contain items of type \StructType\JPSOAP_HotelAvailRelease, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Release value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_HotelAvailRelease[] $release
     * @return \StructType\JPSOAP_HotelAvailReleases
     */
    public function setRelease(array $release = array())
    {
        // validation for constraint: array
        if ('' !== ($releaseArrayErrorMessage = self::validateReleaseForArrayConstraintsFromSetRelease($release))) {
            throw new \InvalidArgumentException($releaseArrayErrorMessage, __LINE__);
        }
        $this->Release = $release;
        return $this;
    }
    /**
     * Add item to Release value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_HotelAvailRelease $item
     * @return \StructType\JPSOAP_HotelAvailReleases
     */
    public function addToRelease(\StructType\JPSOAP_HotelAvailRelease $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_HotelAvailRelease) {
            throw new \InvalidArgumentException(sprintf('The Release property can only contain items of type \StructType\JPSOAP_HotelAvailRelease, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Release[] = $item;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \StructType\JPSOAP_HotelAvailReleases
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param string $timeZone
     * @return \StructType\JPSOAP_HotelAvailReleases
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZone, true), gettype($timeZone)), __LINE__);
        }
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_HotelAvailReleases
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
