<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_PhoneNumber ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_PhoneNumber extends AbstractStructArrayBase
{
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PhoneNumber[]
     */
    public $PhoneNumber;
    /**
     * Constructor method for ArrayOfJP_PhoneNumber
     * @uses ArrayOfJP_PhoneNumber::setPhoneNumber()
     * @param \StructType\JP_PhoneNumber[] $phoneNumber
     */
    public function __construct(array $phoneNumber = array())
    {
        $this
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get PhoneNumber value
     * @return \StructType\JP_PhoneNumber[]|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setPhoneNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoneNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhoneNumberForArrayConstraintsFromSetPhoneNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_PhoneNumberPhoneNumberItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_PhoneNumberPhoneNumberItem instanceof \StructType\JP_PhoneNumber) {
                $invalidValues[] = is_object($arrayOfJP_PhoneNumberPhoneNumberItem) ? get_class($arrayOfJP_PhoneNumberPhoneNumberItem) : sprintf('%s(%s)', gettype($arrayOfJP_PhoneNumberPhoneNumberItem), var_export($arrayOfJP_PhoneNumberPhoneNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhoneNumber property can only contain items of type \StructType\JP_PhoneNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhoneNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PhoneNumber[] $phoneNumber
     * @return \ArrayType\ArrayOfJP_PhoneNumber
     */
    public function setPhoneNumber(array $phoneNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($phoneNumberArrayErrorMessage = self::validatePhoneNumberForArrayConstraintsFromSetPhoneNumber($phoneNumber))) {
            throw new \InvalidArgumentException($phoneNumberArrayErrorMessage, __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Add item to PhoneNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PhoneNumber $item
     * @return \ArrayType\ArrayOfJP_PhoneNumber
     */
    public function addToPhoneNumber(\StructType\JP_PhoneNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PhoneNumber) {
            throw new \InvalidArgumentException(sprintf('The PhoneNumber property can only contain items of type \StructType\JP_PhoneNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PhoneNumber[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_PhoneNumber|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_PhoneNumber|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_PhoneNumber|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_PhoneNumber|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_PhoneNumber|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PhoneNumber
     */
    public function getAttributeName()
    {
        return 'PhoneNumber';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_PhoneNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
