<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Payment ServiceType
 * @subpackage Services
 */
class Payment extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PaymentBooking
     * Meta information extracted from the WSDL
     * - documentation: Credit Card payment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PaymentBooking $parameters
     * @return \StructType\PaymentBookingResponse|bool
     */
    public function PaymentBooking(\StructType\PaymentBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PaymentBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PaymentBookingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
