<?php

namespace EnumType;

/**
 * This class stands for JP_OffersType EnumType
 * @subpackage Enumerations
 */
class JP_OffersType
{
    /**
     * Constant for value 'GRA'
     * @return string 'GRA'
     */
    const VALUE_GRA = 'GRA';
    /**
     * Constant for value 'UGR'
     * @return string 'UGR'
     */
    const VALUE_UGR = 'UGR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GRA
     * @uses self::VALUE_UGR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GRA,
            self::VALUE_UGR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
