<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_HotelAvailAllotment StructType
 * @subpackage Structs
 */
class JPSOAP_HotelAvailAllotment extends JPSOAP_Allotment
{
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $RoomTypeCode;
    /**
     * The IsSecurityAllotment
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsSecurityAllotment;
    /**
     * The IsGuaranteedAllotment
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsGuaranteedAllotment;
    /**
     * The MinimumAllotment
     * @var int
     */
    public $MinimumAllotment;
    /**
     * Constructor method for JPSOAP_HotelAvailAllotment
     * @uses JPSOAP_HotelAvailAllotment::setRoomTypeCode()
     * @uses JPSOAP_HotelAvailAllotment::setIsSecurityAllotment()
     * @uses JPSOAP_HotelAvailAllotment::setIsGuaranteedAllotment()
     * @uses JPSOAP_HotelAvailAllotment::setMinimumAllotment()
     * @param int $roomTypeCode
     * @param bool $isSecurityAllotment
     * @param bool $isGuaranteedAllotment
     * @param int $minimumAllotment
     */
    public function __construct($roomTypeCode = null, $isSecurityAllotment = null, $isGuaranteedAllotment = null, $minimumAllotment = null)
    {
        $this
            ->setRoomTypeCode($roomTypeCode)
            ->setIsSecurityAllotment($isSecurityAllotment)
            ->setIsGuaranteedAllotment($isGuaranteedAllotment)
            ->setMinimumAllotment($minimumAllotment);
    }
    /**
     * Get RoomTypeCode value
     * @return int
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param int $roomTypeCode
     * @return \StructType\JPSOAP_HotelAvailAllotment
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($roomTypeCode) && !(is_int($roomTypeCode) || ctype_digit($roomTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get IsSecurityAllotment value
     * @return bool
     */
    public function getIsSecurityAllotment()
    {
        return $this->IsSecurityAllotment;
    }
    /**
     * Set IsSecurityAllotment value
     * @param bool $isSecurityAllotment
     * @return \StructType\JPSOAP_HotelAvailAllotment
     */
    public function setIsSecurityAllotment($isSecurityAllotment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSecurityAllotment) && !is_bool($isSecurityAllotment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSecurityAllotment, true), gettype($isSecurityAllotment)), __LINE__);
        }
        $this->IsSecurityAllotment = $isSecurityAllotment;
        return $this;
    }
    /**
     * Get IsGuaranteedAllotment value
     * @return bool
     */
    public function getIsGuaranteedAllotment()
    {
        return $this->IsGuaranteedAllotment;
    }
    /**
     * Set IsGuaranteedAllotment value
     * @param bool $isGuaranteedAllotment
     * @return \StructType\JPSOAP_HotelAvailAllotment
     */
    public function setIsGuaranteedAllotment($isGuaranteedAllotment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGuaranteedAllotment) && !is_bool($isGuaranteedAllotment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGuaranteedAllotment, true), gettype($isGuaranteedAllotment)), __LINE__);
        }
        $this->IsGuaranteedAllotment = $isGuaranteedAllotment;
        return $this;
    }
    /**
     * Get MinimumAllotment value
     * @return int|null
     */
    public function getMinimumAllotment()
    {
        return $this->MinimumAllotment;
    }
    /**
     * Set MinimumAllotment value
     * @param int $minimumAllotment
     * @return \StructType\JPSOAP_HotelAvailAllotment
     */
    public function setMinimumAllotment($minimumAllotment = null)
    {
        // validation for constraint: int
        if (!is_null($minimumAllotment) && !(is_int($minimumAllotment) || ctype_digit($minimumAllotment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumAllotment, true), gettype($minimumAllotment)), __LINE__);
        }
        $this->MinimumAllotment = $minimumAllotment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_HotelAvailAllotment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
