<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ZoneInfo StructType
 * @subpackage Structs
 */
class JP_ZoneInfo extends JP_Zone
{
    /**
     * The FullName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FullName;
    /**
     * The NameByLanguages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ZoneNameByLanguage[]
     */
    public $NameByLanguages;
    /**
     * Constructor method for JP_ZoneInfo
     * @uses JP_ZoneInfo::setFullName()
     * @uses JP_ZoneInfo::setNameByLanguages()
     * @param string $fullName
     * @param \StructType\JP_ZoneNameByLanguage[] $nameByLanguages
     */
    public function __construct($fullName = null, array $nameByLanguages = array())
    {
        $this
            ->setFullName($fullName)
            ->setNameByLanguages($nameByLanguages);
    }
    /**
     * Get FullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->FullName;
    }
    /**
     * Set FullName value
     * @param string $fullName
     * @return \StructType\JP_ZoneInfo
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->FullName = $fullName;
        return $this;
    }
    /**
     * Get NameByLanguages value
     * @return \StructType\JP_ZoneNameByLanguage[]|null
     */
    public function getNameByLanguages()
    {
        return $this->NameByLanguages;
    }
    /**
     * This method is responsible for validating the values passed to the setNameByLanguages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameByLanguages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameByLanguagesForArrayConstraintsFromSetNameByLanguages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ZoneInfoNameByLanguagesItem) {
            // validation for constraint: itemType
            if (!$jP_ZoneInfoNameByLanguagesItem instanceof \StructType\JP_ZoneNameByLanguage) {
                $invalidValues[] = is_object($jP_ZoneInfoNameByLanguagesItem) ? get_class($jP_ZoneInfoNameByLanguagesItem) : sprintf('%s(%s)', gettype($jP_ZoneInfoNameByLanguagesItem), var_export($jP_ZoneInfoNameByLanguagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NameByLanguages property can only contain items of type \StructType\JP_ZoneNameByLanguage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NameByLanguages value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ZoneNameByLanguage[] $nameByLanguages
     * @return \StructType\JP_ZoneInfo
     */
    public function setNameByLanguages(array $nameByLanguages = array())
    {
        // validation for constraint: array
        if ('' !== ($nameByLanguagesArrayErrorMessage = self::validateNameByLanguagesForArrayConstraintsFromSetNameByLanguages($nameByLanguages))) {
            throw new \InvalidArgumentException($nameByLanguagesArrayErrorMessage, __LINE__);
        }
        $this->NameByLanguages = $nameByLanguages;
        return $this;
    }
    /**
     * Add item to NameByLanguages value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ZoneNameByLanguage $item
     * @return \StructType\JP_ZoneInfo
     */
    public function addToNameByLanguages(\StructType\JP_ZoneNameByLanguage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ZoneNameByLanguage) {
            throw new \InvalidArgumentException(sprintf('The NameByLanguages property can only contain items of type \StructType\JP_ZoneNameByLanguage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NameByLanguages[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ZoneInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
