<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_InfoExtra StructType
 * @subpackage Structs
 */
class JP_InfoExtra extends AbstractStructBase
{
    /**
     * The ExternalLocator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalLocator;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * Constructor method for JP_InfoExtra
     * @uses JP_InfoExtra::setExternalLocator()
     * @uses JP_InfoExtra::setSource()
     * @param string $externalLocator
     * @param string $source
     */
    public function __construct($externalLocator = null, $source = null)
    {
        $this
            ->setExternalLocator($externalLocator)
            ->setSource($source);
    }
    /**
     * Get ExternalLocator value
     * @return string|null
     */
    public function getExternalLocator()
    {
        return $this->ExternalLocator;
    }
    /**
     * Set ExternalLocator value
     * @param string $externalLocator
     * @return \StructType\JP_InfoExtra
     */
    public function setExternalLocator($externalLocator = null)
    {
        // validation for constraint: string
        if (!is_null($externalLocator) && !is_string($externalLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalLocator, true), gettype($externalLocator)), __LINE__);
        }
        $this->ExternalLocator = $externalLocator;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\JP_InfoExtra
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_InfoExtra
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
