<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetZoneInfoList
     * Meta information extracted from the WSDL
     * - documentation: Performs a request to read the search zones list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetZoneInfoList $parameters
     * @return \StructType\GetZoneInfoListResponse|bool
     */
    public function GetZoneInfoList(\StructType\GetZoneInfoList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetZoneInfoList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPermissionList
     * Meta information extracted from the WSDL
     * - documentation: Performs a request to read the user permissions.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPermissionList $parameters
     * @return \StructType\GetPermissionListResponse|bool
     */
    public function GetPermissionList(\StructType\GetPermissionList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPermissionList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetPermissionListResponse|\StructType\GetZoneInfoListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
