<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseData StructType
 * @subpackage Structs
 */
class JP_CruiseData extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Description
     */
    public $Description;
    /**
     * The LongDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Description
     */
    public $LongDescription;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Images;
    /**
     * The ImagesLong
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ImageLong
     */
    public $ImagesLong;
    /**
     * The Ship
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Ship
     */
    public $Ship;
    /**
     * The Categories
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CruiseCategory
     */
    public $Categories;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_CruiseData
     * @uses JP_CruiseData::setName()
     * @uses JP_CruiseData::setDescription()
     * @uses JP_CruiseData::setLongDescription()
     * @uses JP_CruiseData::setImages()
     * @uses JP_CruiseData::setImagesLong()
     * @uses JP_CruiseData::setShip()
     * @uses JP_CruiseData::setCategories()
     * @uses JP_CruiseData::setCode()
     * @param string $name
     * @param \StructType\JP_Description $description
     * @param \StructType\JP_Description $longDescription
     * @param \ArrayType\ArrayOfString1 $images
     * @param \ArrayType\ArrayOfJP_ImageLong $imagesLong
     * @param \StructType\JP_Ship $ship
     * @param \ArrayType\ArrayOfJP_CruiseCategory $categories
     * @param string $code
     */
    public function __construct($name = null, \StructType\JP_Description $description = null, \StructType\JP_Description $longDescription = null, \ArrayType\ArrayOfString1 $images = null, \ArrayType\ArrayOfJP_ImageLong $imagesLong = null, \StructType\JP_Ship $ship = null, \ArrayType\ArrayOfJP_CruiseCategory $categories = null, $code = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setLongDescription($longDescription)
            ->setImages($images)
            ->setImagesLong($imagesLong)
            ->setShip($ship)
            ->setCategories($categories)
            ->setCode($code);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_CruiseData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\JP_Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\JP_Description $description
     * @return \StructType\JP_CruiseData
     */
    public function setDescription(\StructType\JP_Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get LongDescription value
     * @return \StructType\JP_Description|null
     */
    public function getLongDescription()
    {
        return $this->LongDescription;
    }
    /**
     * Set LongDescription value
     * @param \StructType\JP_Description $longDescription
     * @return \StructType\JP_CruiseData
     */
    public function setLongDescription(\StructType\JP_Description $longDescription = null)
    {
        $this->LongDescription = $longDescription;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString1 $images
     * @return \StructType\JP_CruiseData
     */
    public function setImages(\ArrayType\ArrayOfString1 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get ImagesLong value
     * @return \ArrayType\ArrayOfJP_ImageLong|null
     */
    public function getImagesLong()
    {
        return $this->ImagesLong;
    }
    /**
     * Set ImagesLong value
     * @param \ArrayType\ArrayOfJP_ImageLong $imagesLong
     * @return \StructType\JP_CruiseData
     */
    public function setImagesLong(\ArrayType\ArrayOfJP_ImageLong $imagesLong = null)
    {
        $this->ImagesLong = $imagesLong;
        return $this;
    }
    /**
     * Get Ship value
     * @return \StructType\JP_Ship|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \StructType\JP_Ship $ship
     * @return \StructType\JP_CruiseData
     */
    public function setShip(\StructType\JP_Ship $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get Categories value
     * @return \ArrayType\ArrayOfJP_CruiseCategory|null
     */
    public function getCategories()
    {
        return $this->Categories;
    }
    /**
     * Set Categories value
     * @param \ArrayType\ArrayOfJP_CruiseCategory $categories
     * @return \StructType\JP_CruiseData
     */
    public function setCategories(\ArrayType\ArrayOfJP_CruiseCategory $categories = null)
    {
        $this->Categories = $categories;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_CruiseData
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
