<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_Price StructType
 * @subpackage Structs
 */
class JPSOAP_Price extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Recommended
     * @var float
     */
    public $Recommended;
    /**
     * Constructor method for JPSOAP_Price
     * @uses JPSOAP_Price::setAmount()
     * @uses JPSOAP_Price::setRecommended()
     * @param float $amount
     * @param float $recommended
     */
    public function __construct($amount = null, $recommended = null)
    {
        $this
            ->setAmount($amount)
            ->setRecommended($recommended);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\JPSOAP_Price
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Recommended value
     * @return float|null
     */
    public function getRecommended()
    {
        return $this->Recommended;
    }
    /**
     * Set Recommended value
     * @param float $recommended
     * @return \StructType\JPSOAP_Price
     */
    public function setRecommended($recommended = null)
    {
        // validation for constraint: float
        if (!is_null($recommended) && !(is_float($recommended) || is_numeric($recommended))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recommended, true), gettype($recommended)), __LINE__);
        }
        $this->Recommended = $recommended;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_Price
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
