<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CheckPaymentResponse StructType
 * @subpackage Structs
 */
class JP_CheckPaymentResponse extends AbstractStructBase
{
    /**
     * The CheckPaymentToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckPaymentToken;
    /**
     * The Score
     * @var string
     */
    public $Score;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The IsFraud
     * @var bool
     */
    public $IsFraud;
    /**
     * Constructor method for JP_CheckPaymentResponse
     * @uses JP_CheckPaymentResponse::setCheckPaymentToken()
     * @uses JP_CheckPaymentResponse::setScore()
     * @uses JP_CheckPaymentResponse::setStatus()
     * @uses JP_CheckPaymentResponse::setIsFraud()
     * @param string $checkPaymentToken
     * @param string $score
     * @param string $status
     * @param bool $isFraud
     */
    public function __construct($checkPaymentToken = null, $score = null, $status = null, $isFraud = null)
    {
        $this
            ->setCheckPaymentToken($checkPaymentToken)
            ->setScore($score)
            ->setStatus($status)
            ->setIsFraud($isFraud);
    }
    /**
     * Get CheckPaymentToken value
     * @return string|null
     */
    public function getCheckPaymentToken()
    {
        return $this->CheckPaymentToken;
    }
    /**
     * Set CheckPaymentToken value
     * @param string $checkPaymentToken
     * @return \StructType\JP_CheckPaymentResponse
     */
    public function setCheckPaymentToken($checkPaymentToken = null)
    {
        // validation for constraint: string
        if (!is_null($checkPaymentToken) && !is_string($checkPaymentToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkPaymentToken, true), gettype($checkPaymentToken)), __LINE__);
        }
        $this->CheckPaymentToken = $checkPaymentToken;
        return $this;
    }
    /**
     * Get Score value
     * @return string|null
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param string $score
     * @return \StructType\JP_CheckPaymentResponse
     */
    public function setScore($score = null)
    {
        // validation for constraint: string
        if (!is_null($score) && !is_string($score)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($score, true), gettype($score)), __LINE__);
        }
        $this->Score = $score;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\JP_CheckPaymentResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get IsFraud value
     * @return bool|null
     */
    public function getIsFraud()
    {
        return $this->IsFraud;
    }
    /**
     * Set IsFraud value
     * @param bool $isFraud
     * @return \StructType\JP_CheckPaymentResponse
     */
    public function setIsFraud($isFraud = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFraud) && !is_bool($isFraud)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFraud, true), gettype($isFraud)), __LINE__);
        }
        $this->IsFraud = $isFraud;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CheckPaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
