<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_Order StructType
 * @subpackage Structs
 */
class JPSOAP_Order extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Order;
    /**
     * Constructor method for JPSOAP_Order
     * @uses JPSOAP_Order::setOrder()
     * @param int $order
     */
    public function __construct($order = null)
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get Order value
     * @return int
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JPSOAP_Order
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_Order
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
