<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_HotelRoom ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_HotelRoom extends AbstractStructArrayBase
{
    /**
     * The HotelRoom
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelRoom[]
     */
    public $HotelRoom;
    /**
     * Constructor method for ArrayOfJP_HotelRoom
     * @uses ArrayOfJP_HotelRoom::setHotelRoom()
     * @param \StructType\JP_HotelRoom[] $hotelRoom
     */
    public function __construct(array $hotelRoom = array())
    {
        $this
            ->setHotelRoom($hotelRoom);
    }
    /**
     * Get HotelRoom value
     * @return \StructType\JP_HotelRoom[]|null
     */
    public function getHotelRoom()
    {
        return $this->HotelRoom;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelRoomForArrayConstraintsFromSetHotelRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_HotelRoomHotelRoomItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_HotelRoomHotelRoomItem instanceof \StructType\JP_HotelRoom) {
                $invalidValues[] = is_object($arrayOfJP_HotelRoomHotelRoomItem) ? get_class($arrayOfJP_HotelRoomHotelRoomItem) : sprintf('%s(%s)', gettype($arrayOfJP_HotelRoomHotelRoomItem), var_export($arrayOfJP_HotelRoomHotelRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelRoom property can only contain items of type \StructType\JP_HotelRoom, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelRoom[] $hotelRoom
     * @return \ArrayType\ArrayOfJP_HotelRoom
     */
    public function setHotelRoom(array $hotelRoom = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelRoomArrayErrorMessage = self::validateHotelRoomForArrayConstraintsFromSetHotelRoom($hotelRoom))) {
            throw new \InvalidArgumentException($hotelRoomArrayErrorMessage, __LINE__);
        }
        $this->HotelRoom = $hotelRoom;
        return $this;
    }
    /**
     * Add item to HotelRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelRoom $item
     * @return \ArrayType\ArrayOfJP_HotelRoom
     */
    public function addToHotelRoom(\StructType\JP_HotelRoom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelRoom) {
            throw new \InvalidArgumentException(sprintf('The HotelRoom property can only contain items of type \StructType\JP_HotelRoom, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelRoom[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_HotelRoom|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_HotelRoom|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_HotelRoom|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_HotelRoom|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_HotelRoom|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HotelRoom
     */
    public function getAttributeName()
    {
        return 'HotelRoom';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_HotelRoom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
