<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ShoppingBasket StructType
 * @subpackage Structs
 */
class JP_ShoppingBasket extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The AgencyCode
     * @var int
     */
    public $AgencyCode;
    /**
     * Constructor method for JP_ShoppingBasket
     * @uses JP_ShoppingBasket::setCode()
     * @uses JP_ShoppingBasket::setAgencyCode()
     * @param string $code
     * @param int $agencyCode
     */
    public function __construct($code = null, $agencyCode = null)
    {
        $this
            ->setCode($code)
            ->setAgencyCode($agencyCode);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ShoppingBasket
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get AgencyCode value
     * @return int|null
     */
    public function getAgencyCode()
    {
        return $this->AgencyCode;
    }
    /**
     * Set AgencyCode value
     * @param int $agencyCode
     * @return \StructType\JP_ShoppingBasket
     */
    public function setAgencyCode($agencyCode = null)
    {
        // validation for constraint: int
        if (!is_null($agencyCode) && !(is_int($agencyCode) || ctype_digit($agencyCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agencyCode, true), gettype($agencyCode)), __LINE__);
        }
        $this->AgencyCode = $agencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ShoppingBasket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
