<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Visa ServiceType
 * @subpackage Services
 */
class Visa extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VisaBooking
     * Meta information extracted from the WSDL
     * - documentation: Booking for visa.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VisaBooking $parameters
     * @return \StructType\VisaBookingResponse|bool
     */
    public function VisaBooking(\StructType\VisaBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VisaBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VisaAvail
     * Meta information extracted from the WSDL
     * - documentation: Availability for visas.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VisaAvail $parameters
     * @return \StructType\VisaAvailResponse|bool
     */
    public function VisaAvail(\StructType\VisaAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VisaAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VisaPortfolio
     * Meta information extracted from the WSDL
     * - documentation: Paged Portfolio of Visas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VisaPortfolio $parameters
     * @return \StructType\VisaPortfolioResponse|bool
     */
    public function VisaPortfolio(\StructType\VisaPortfolio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VisaPortfolio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VisaCatalogueData
     * Meta information extracted from the WSDL
     * - documentation: Catalogue For Visas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VisaCatalogueData $parameters
     * @return \StructType\VisaCatalogueDataResponse|bool
     */
    public function VisaCatalogueData(\StructType\VisaCatalogueData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VisaCatalogueData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VisaCheckAvail
     * Meta information extracted from the WSDL
     * - documentation: CheckAvail for visas services.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VisaCheckAvail $parameters
     * @return \StructType\VisaCheckAvailResponse|bool
     */
    public function VisaCheckAvail(\StructType\VisaCheckAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VisaCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VisaBookingRules
     * Meta information extracted from the WSDL
     * - documentation: BookingRules Of visas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VisaBookingRules $parameters
     * @return \StructType\VisaBookingRulesResponse|bool
     */
    public function VisaBookingRules(\StructType\VisaBookingRules $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->VisaBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VisaAvailResponse|\StructType\VisaBookingResponse|\StructType\VisaBookingRulesResponse|\StructType\VisaCatalogueDataResponse|\StructType\VisaCheckAvailResponse|\StructType\VisaPortfolioResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
