<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Day ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Day extends AbstractStructArrayBase
{
    /**
     * The Day
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Day[]
     */
    public $Day;
    /**
     * Constructor method for ArrayOfJP_Day
     * @uses ArrayOfJP_Day::setDay()
     * @param \StructType\JP_Day[] $day
     */
    public function __construct(array $day = array())
    {
        $this
            ->setDay($day);
    }
    /**
     * Get Day value
     * @return \StructType\JP_Day[]|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * This method is responsible for validating the values passed to the setDay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDay method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDayForArrayConstraintsFromSetDay(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_DayDayItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_DayDayItem instanceof \StructType\JP_Day) {
                $invalidValues[] = is_object($arrayOfJP_DayDayItem) ? get_class($arrayOfJP_DayDayItem) : sprintf('%s(%s)', gettype($arrayOfJP_DayDayItem), var_export($arrayOfJP_DayDayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Day property can only contain items of type \StructType\JP_Day, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Day value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Day[] $day
     * @return \ArrayType\ArrayOfJP_Day
     */
    public function setDay(array $day = array())
    {
        // validation for constraint: array
        if ('' !== ($dayArrayErrorMessage = self::validateDayForArrayConstraintsFromSetDay($day))) {
            throw new \InvalidArgumentException($dayArrayErrorMessage, __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Add item to Day value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Day $item
     * @return \ArrayType\ArrayOfJP_Day
     */
    public function addToDay(\StructType\JP_Day $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Day) {
            throw new \InvalidArgumentException(sprintf('The Day property can only contain items of type \StructType\JP_Day, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Day[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Day|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Day|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Day|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Day|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Day|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Day
     */
    public function getAttributeName()
    {
        return 'Day';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Day
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
