<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RentacarItem StructType
 * @subpackage Structs
 */
class JP_RentacarItem extends JP_BaseItem
{
    /**
     * The RentacarInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarInfo
     */
    public $RentacarInfo;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The RentacarLocationDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RentacarBookLocationDetails
     */
    public $RentacarLocationDetails;
    /**
     * The RelPaxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPax
     */
    public $RelPaxes;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Hour
     * @var string
     */
    public $Hour;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The HourEnd
     * @var string
     */
    public $HourEnd;
    /**
     * Constructor method for JP_RentacarItem
     * @uses JP_RentacarItem::setRentacarInfo()
     * @uses JP_RentacarItem::setAdditionalElements()
     * @uses JP_RentacarItem::setRentacarLocationDetails()
     * @uses JP_RentacarItem::setRelPaxes()
     * @uses JP_RentacarItem::setStart()
     * @uses JP_RentacarItem::setHour()
     * @uses JP_RentacarItem::setEnd()
     * @uses JP_RentacarItem::setHourEnd()
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     * @param \StructType\JP_RentacarBookLocationDetails $rentacarLocationDetails
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @param string $start
     * @param string $hour
     * @param string $end
     * @param string $hourEnd
     */
    public function __construct(\StructType\JP_RentacarInfo $rentacarInfo = null, \StructType\JP_RentacarAdditionalElements $additionalElements = null, \StructType\JP_RentacarBookLocationDetails $rentacarLocationDetails = null, \ArrayType\ArrayOfJP_RelPax $relPaxes = null, $start = null, $hour = null, $end = null, $hourEnd = null)
    {
        $this
            ->setRentacarInfo($rentacarInfo)
            ->setAdditionalElements($additionalElements)
            ->setRentacarLocationDetails($rentacarLocationDetails)
            ->setRelPaxes($relPaxes)
            ->setStart($start)
            ->setHour($hour)
            ->setEnd($end)
            ->setHourEnd($hourEnd);
    }
    /**
     * Get RentacarInfo value
     * @return \StructType\JP_RentacarInfo|null
     */
    public function getRentacarInfo()
    {
        return $this->RentacarInfo;
    }
    /**
     * Set RentacarInfo value
     * @param \StructType\JP_RentacarInfo $rentacarInfo
     * @return \StructType\JP_RentacarItem
     */
    public function setRentacarInfo(\StructType\JP_RentacarInfo $rentacarInfo = null)
    {
        $this->RentacarInfo = $rentacarInfo;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_RentacarAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_RentacarAdditionalElements $additionalElements
     * @return \StructType\JP_RentacarItem
     */
    public function setAdditionalElements(\StructType\JP_RentacarAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get RentacarLocationDetails value
     * @return \StructType\JP_RentacarBookLocationDetails|null
     */
    public function getRentacarLocationDetails()
    {
        return $this->RentacarLocationDetails;
    }
    /**
     * Set RentacarLocationDetails value
     * @param \StructType\JP_RentacarBookLocationDetails $rentacarLocationDetails
     * @return \StructType\JP_RentacarItem
     */
    public function setRentacarLocationDetails(\StructType\JP_RentacarBookLocationDetails $rentacarLocationDetails = null)
    {
        $this->RentacarLocationDetails = $rentacarLocationDetails;
        return $this;
    }
    /**
     * Get RelPaxes value
     * @return \ArrayType\ArrayOfJP_RelPax|null
     */
    public function getRelPaxes()
    {
        return $this->RelPaxes;
    }
    /**
     * Set RelPaxes value
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @return \StructType\JP_RentacarItem
     */
    public function setRelPaxes(\ArrayType\ArrayOfJP_RelPax $relPaxes = null)
    {
        $this->RelPaxes = $relPaxes;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_RentacarItem
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Hour value
     * @return string|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param string $hour
     * @return \StructType\JP_RentacarItem
     */
    public function setHour($hour = null)
    {
        // validation for constraint: string
        if (!is_null($hour) && !is_string($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hour, true), gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_RentacarItem
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get HourEnd value
     * @return string|null
     */
    public function getHourEnd()
    {
        return $this->HourEnd;
    }
    /**
     * Set HourEnd value
     * @param string $hourEnd
     * @return \StructType\JP_RentacarItem
     */
    public function setHourEnd($hourEnd = null)
    {
        // validation for constraint: string
        if (!is_null($hourEnd) && !is_string($hourEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hourEnd, true), gettype($hourEnd)), __LINE__);
        }
        $this->HourEnd = $hourEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RentacarItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
