<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceInfo StructType
 * @subpackage Structs
 */
class JP_ServiceInfo extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ImageLong
     */
    public $Images;
    /**
     * The CancellationPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CancellationPolicyRules
     */
    public $CancellationPolicies;
    /**
     * The AdditionalDescriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_InfoDescription
     */
    public $AdditionalDescriptions;
    /**
     * The AdditionalFeatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_AdditionalFeature
     */
    public $AdditionalFeatures;
    /**
     * Constructor method for JP_ServiceInfo
     * @uses JP_ServiceInfo::setName()
     * @uses JP_ServiceInfo::setDescription()
     * @uses JP_ServiceInfo::setImages()
     * @uses JP_ServiceInfo::setCancellationPolicies()
     * @uses JP_ServiceInfo::setAdditionalDescriptions()
     * @uses JP_ServiceInfo::setAdditionalFeatures()
     * @param string $name
     * @param string $description
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @param \ArrayType\ArrayOfJP_CancellationPolicyRules $cancellationPolicies
     * @param \ArrayType\ArrayOfJP_InfoDescription $additionalDescriptions
     * @param \ArrayType\ArrayOfJP_AdditionalFeature $additionalFeatures
     */
    public function __construct($name = null, $description = null, \ArrayType\ArrayOfJP_ImageLong $images = null, \ArrayType\ArrayOfJP_CancellationPolicyRules $cancellationPolicies = null, \ArrayType\ArrayOfJP_InfoDescription $additionalDescriptions = null, \ArrayType\ArrayOfJP_AdditionalFeature $additionalFeatures = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setImages($images)
            ->setCancellationPolicies($cancellationPolicies)
            ->setAdditionalDescriptions($additionalDescriptions)
            ->setAdditionalFeatures($additionalFeatures);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ServiceInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_ServiceInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfJP_ImageLong|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @return \StructType\JP_ServiceInfo
     */
    public function setImages(\ArrayType\ArrayOfJP_ImageLong $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get CancellationPolicies value
     * @return \ArrayType\ArrayOfJP_CancellationPolicyRules|null
     */
    public function getCancellationPolicies()
    {
        return $this->CancellationPolicies;
    }
    /**
     * Set CancellationPolicies value
     * @param \ArrayType\ArrayOfJP_CancellationPolicyRules $cancellationPolicies
     * @return \StructType\JP_ServiceInfo
     */
    public function setCancellationPolicies(\ArrayType\ArrayOfJP_CancellationPolicyRules $cancellationPolicies = null)
    {
        $this->CancellationPolicies = $cancellationPolicies;
        return $this;
    }
    /**
     * Get AdditionalDescriptions value
     * @return \ArrayType\ArrayOfJP_InfoDescription|null
     */
    public function getAdditionalDescriptions()
    {
        return $this->AdditionalDescriptions;
    }
    /**
     * Set AdditionalDescriptions value
     * @param \ArrayType\ArrayOfJP_InfoDescription $additionalDescriptions
     * @return \StructType\JP_ServiceInfo
     */
    public function setAdditionalDescriptions(\ArrayType\ArrayOfJP_InfoDescription $additionalDescriptions = null)
    {
        $this->AdditionalDescriptions = $additionalDescriptions;
        return $this;
    }
    /**
     * Get AdditionalFeatures value
     * @return \ArrayType\ArrayOfJP_AdditionalFeature|null
     */
    public function getAdditionalFeatures()
    {
        return $this->AdditionalFeatures;
    }
    /**
     * Set AdditionalFeatures value
     * @param \ArrayType\ArrayOfJP_AdditionalFeature $additionalFeatures
     * @return \StructType\JP_ServiceInfo
     */
    public function setAdditionalFeatures(\ArrayType\ArrayOfJP_AdditionalFeature $additionalFeatures = null)
    {
        $this->AdditionalFeatures = $additionalFeatures;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
