<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_RelPax ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_RelPax extends AbstractStructArrayBase
{
    /**
     * The RelPax
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_RelPax[]
     */
    public $RelPax;
    /**
     * Constructor method for ArrayOfJP_RelPax
     * @uses ArrayOfJP_RelPax::setRelPax()
     * @param \StructType\JP_RelPax[] $relPax
     */
    public function __construct(array $relPax = array())
    {
        $this
            ->setRelPax($relPax);
    }
    /**
     * Get RelPax value
     * @return \StructType\JP_RelPax[]|null
     */
    public function getRelPax()
    {
        return $this->RelPax;
    }
    /**
     * This method is responsible for validating the values passed to the setRelPax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelPax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelPaxForArrayConstraintsFromSetRelPax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_RelPaxRelPaxItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_RelPaxRelPaxItem instanceof \StructType\JP_RelPax) {
                $invalidValues[] = is_object($arrayOfJP_RelPaxRelPaxItem) ? get_class($arrayOfJP_RelPaxRelPaxItem) : sprintf('%s(%s)', gettype($arrayOfJP_RelPaxRelPaxItem), var_export($arrayOfJP_RelPaxRelPaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelPax property can only contain items of type \StructType\JP_RelPax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelPax value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RelPax[] $relPax
     * @return \ArrayType\ArrayOfJP_RelPax
     */
    public function setRelPax(array $relPax = array())
    {
        // validation for constraint: array
        if ('' !== ($relPaxArrayErrorMessage = self::validateRelPaxForArrayConstraintsFromSetRelPax($relPax))) {
            throw new \InvalidArgumentException($relPaxArrayErrorMessage, __LINE__);
        }
        $this->RelPax = $relPax;
        return $this;
    }
    /**
     * Add item to RelPax value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RelPax $item
     * @return \ArrayType\ArrayOfJP_RelPax
     */
    public function addToRelPax(\StructType\JP_RelPax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RelPax) {
            throw new \InvalidArgumentException(sprintf('The RelPax property can only contain items of type \StructType\JP_RelPax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelPax[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_RelPax|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_RelPax|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_RelPax|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_RelPax|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_RelPax|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RelPax
     */
    public function getAttributeName()
    {
        return 'RelPax';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_RelPax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
