<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_AdditionalPoliciesGroup StructType
 * @subpackage Structs
 */
class JP_AdditionalPoliciesGroup extends AbstractStructBase
{
    /**
     * The AdditionalPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_AdditionalPolicy[]
     */
    public $AdditionalPolicy;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for JP_AdditionalPoliciesGroup
     * @uses JP_AdditionalPoliciesGroup::setAdditionalPolicy()
     * @uses JP_AdditionalPoliciesGroup::setType()
     * @uses JP_AdditionalPoliciesGroup::setCurrencyCode()
     * @param \StructType\JP_AdditionalPolicy[] $additionalPolicy
     * @param string $type
     * @param string $currencyCode
     */
    public function __construct(array $additionalPolicy = array(), $type = null, $currencyCode = null)
    {
        $this
            ->setAdditionalPolicy($additionalPolicy)
            ->setType($type)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get AdditionalPolicy value
     * @return \StructType\JP_AdditionalPolicy[]|null
     */
    public function getAdditionalPolicy()
    {
        return $this->AdditionalPolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalPolicyForArrayConstraintsFromSetAdditionalPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_AdditionalPoliciesGroupAdditionalPolicyItem) {
            // validation for constraint: itemType
            if (!$jP_AdditionalPoliciesGroupAdditionalPolicyItem instanceof \StructType\JP_AdditionalPolicy) {
                $invalidValues[] = is_object($jP_AdditionalPoliciesGroupAdditionalPolicyItem) ? get_class($jP_AdditionalPoliciesGroupAdditionalPolicyItem) : sprintf('%s(%s)', gettype($jP_AdditionalPoliciesGroupAdditionalPolicyItem), var_export($jP_AdditionalPoliciesGroupAdditionalPolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalPolicy property can only contain items of type \StructType\JP_AdditionalPolicy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_AdditionalPolicy[] $additionalPolicy
     * @return \StructType\JP_AdditionalPoliciesGroup
     */
    public function setAdditionalPolicy(array $additionalPolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalPolicyArrayErrorMessage = self::validateAdditionalPolicyForArrayConstraintsFromSetAdditionalPolicy($additionalPolicy))) {
            throw new \InvalidArgumentException($additionalPolicyArrayErrorMessage, __LINE__);
        }
        $this->AdditionalPolicy = $additionalPolicy;
        return $this;
    }
    /**
     * Add item to AdditionalPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_AdditionalPolicy $item
     * @return \StructType\JP_AdditionalPoliciesGroup
     */
    public function addToAdditionalPolicy(\StructType\JP_AdditionalPolicy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_AdditionalPolicy) {
            throw new \InvalidArgumentException(sprintf('The AdditionalPolicy property can only contain items of type \StructType\JP_AdditionalPolicy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalPolicy[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\JP_AdditionalPoliciesGroup
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\JP_AdditionalPoliciesGroup
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_AdditionalPoliciesGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
