<?php

namespace EnumType;

/**
 * This class stands for JP_PackageContracts EnumType
 * @subpackage Enumerations
 */
class JP_PackageContracts
{
    /**
     * Constant for value 'Hotel'
     * @return string 'Hotel'
     */
    const VALUE_HOTEL = 'Hotel';
    /**
     * Constant for value 'Package'
     * @return string 'Package'
     */
    const VALUE_PACKAGE = 'Package';
    /**
     * Constant for value 'OnlyPackage'
     * @return string 'OnlyPackage'
     */
    const VALUE_ONLY_PACKAGE = 'OnlyPackage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HOTEL
     * @uses self::VALUE_PACKAGE
     * @uses self::VALUE_ONLY_PACKAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HOTEL,
            self::VALUE_PACKAGE,
            self::VALUE_ONLY_PACKAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
