<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Flight ServiceType
 * @subpackage Services
 */
class Flight extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FlightBooking
     * Meta information extracted from the WSDL
     * - documentation: Booking for flights.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FlightBooking $parameters
     * @return \StructType\FlightBookingResponse|bool
     */
    public function FlightBooking(\StructType\FlightBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FlightBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FlightTicketing
     * Meta information extracted from the WSDL
     * - documentation: Ticketing for flights.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FlightTicketing $parameters
     * @return \StructType\FlightTicketingResponse|bool
     */
    public function FlightTicketing(\StructType\FlightTicketing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FlightTicketing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FlightAvail
     * Meta information extracted from the WSDL
     * - documentation: Availability for Flights.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FlightAvail $parameters
     * @return \StructType\FlightAvailResponse|bool
     */
    public function FlightAvail(\StructType\FlightAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FlightAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FlightCheckAvail
     * Meta information extracted from the WSDL
     * - documentation: CheckAvail for Flights.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FlightCheckAvail $parameters
     * @return \StructType\FlightCheckAvailResponse|bool
     */
    public function FlightCheckAvail(\StructType\FlightCheckAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FlightCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FlightBookingRules
     * Meta information extracted from the WSDL
     * - documentation: BookingRules Of Flights
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FlightBookingRules $parameters
     * @return \StructType\FlightBookingRulesResponse|bool
     */
    public function FlightBookingRules(\StructType\FlightBookingRules $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FlightBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FlightAvailResponse|\StructType\FlightBookingResponse|\StructType\FlightBookingRulesResponse|\StructType\FlightCheckAvailResponse|\StructType\FlightTicketingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
