<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_HotelRatePlanOffer StructType
 * @subpackage Structs
 */
class JPSOAP_HotelRatePlanOffer extends JPSOAP_BaseSupleOfferRest
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Priority;
    /**
     * The ApplicationRules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_ApplicationRulesOffers
     */
    public $ApplicationRules;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_SuppleOfferPrices
     */
    public $Prices;
    /**
     * The Allotment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_Allotment
     */
    public $Allotment;
    /**
     * The FreeNights
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_HotelRatePlanFreeNightsOffer
     */
    public $FreeNights;
    /**
     * The FreePaxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_HotelRatePlanFreePaxesOffer
     */
    public $FreePaxes;
    /**
     * The BoardUpgrade
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_HotelRatePlanBoardUpgradeOffer
     */
    public $BoardUpgrade;
    /**
     * The RoomUpgrade
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_HotelRatePlanRoomUpgradeOffer
     */
    public $RoomUpgrade;
    /**
     * The PaymentConditions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_HotelRatePlanOfferPaymentConditions
     */
    public $PaymentConditions;
    /**
     * The PromoCode
     * @var string
     */
    public $PromoCode;
    /**
     * The MandatoryPromoCode
     * @var bool
     */
    public $MandatoryPromoCode;
    /**
     * The BaseBoardCode
     * @var int
     */
    public $BaseBoardCode;
    /**
     * The SeasonOrder
     * @var int
     */
    public $SeasonOrder;
    /**
     * Constructor method for JPSOAP_HotelRatePlanOffer
     * @uses JPSOAP_HotelRatePlanOffer::setType()
     * @uses JPSOAP_HotelRatePlanOffer::setPriority()
     * @uses JPSOAP_HotelRatePlanOffer::setApplicationRules()
     * @uses JPSOAP_HotelRatePlanOffer::setPrices()
     * @uses JPSOAP_HotelRatePlanOffer::setAllotment()
     * @uses JPSOAP_HotelRatePlanOffer::setFreeNights()
     * @uses JPSOAP_HotelRatePlanOffer::setFreePaxes()
     * @uses JPSOAP_HotelRatePlanOffer::setBoardUpgrade()
     * @uses JPSOAP_HotelRatePlanOffer::setRoomUpgrade()
     * @uses JPSOAP_HotelRatePlanOffer::setPaymentConditions()
     * @uses JPSOAP_HotelRatePlanOffer::setPromoCode()
     * @uses JPSOAP_HotelRatePlanOffer::setMandatoryPromoCode()
     * @uses JPSOAP_HotelRatePlanOffer::setBaseBoardCode()
     * @uses JPSOAP_HotelRatePlanOffer::setSeasonOrder()
     * @param string $type
     * @param int $priority
     * @param \StructType\JPSOAP_ApplicationRulesOffers $applicationRules
     * @param \StructType\JPSOAP_SuppleOfferPrices $prices
     * @param \ArrayType\ArrayOfJPSOAP_Allotment $allotment
     * @param \StructType\JPSOAP_HotelRatePlanFreeNightsOffer $freeNights
     * @param \StructType\JPSOAP_HotelRatePlanFreePaxesOffer $freePaxes
     * @param \StructType\JPSOAP_HotelRatePlanBoardUpgradeOffer $boardUpgrade
     * @param \StructType\JPSOAP_HotelRatePlanRoomUpgradeOffer $roomUpgrade
     * @param \StructType\JPSOAP_HotelRatePlanOfferPaymentConditions $paymentConditions
     * @param string $promoCode
     * @param bool $mandatoryPromoCode
     * @param int $baseBoardCode
     * @param int $seasonOrder
     */
    public function __construct($type = null, $priority = null, \StructType\JPSOAP_ApplicationRulesOffers $applicationRules = null, \StructType\JPSOAP_SuppleOfferPrices $prices = null, \ArrayType\ArrayOfJPSOAP_Allotment $allotment = null, \StructType\JPSOAP_HotelRatePlanFreeNightsOffer $freeNights = null, \StructType\JPSOAP_HotelRatePlanFreePaxesOffer $freePaxes = null, \StructType\JPSOAP_HotelRatePlanBoardUpgradeOffer $boardUpgrade = null, \StructType\JPSOAP_HotelRatePlanRoomUpgradeOffer $roomUpgrade = null, \StructType\JPSOAP_HotelRatePlanOfferPaymentConditions $paymentConditions = null, $promoCode = null, $mandatoryPromoCode = null, $baseBoardCode = null, $seasonOrder = null)
    {
        $this
            ->setType($type)
            ->setPriority($priority)
            ->setApplicationRules($applicationRules)
            ->setPrices($prices)
            ->setAllotment($allotment)
            ->setFreeNights($freeNights)
            ->setFreePaxes($freePaxes)
            ->setBoardUpgrade($boardUpgrade)
            ->setRoomUpgrade($roomUpgrade)
            ->setPaymentConditions($paymentConditions)
            ->setPromoCode($promoCode)
            ->setMandatoryPromoCode($mandatoryPromoCode)
            ->setBaseBoardCode($baseBoardCode)
            ->setSeasonOrder($seasonOrder);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JPSOAP_OfferType::valueIsValid()
     * @uses \EnumType\JPSOAP_OfferType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_OfferType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JPSOAP_OfferType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\JPSOAP_OfferType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Priority value
     * @return int
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get ApplicationRules value
     * @return \StructType\JPSOAP_ApplicationRulesOffers|null
     */
    public function getApplicationRules()
    {
        return $this->ApplicationRules;
    }
    /**
     * Set ApplicationRules value
     * @param \StructType\JPSOAP_ApplicationRulesOffers $applicationRules
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setApplicationRules(\StructType\JPSOAP_ApplicationRulesOffers $applicationRules = null)
    {
        $this->ApplicationRules = $applicationRules;
        return $this;
    }
    /**
     * Get Prices value
     * @return \StructType\JPSOAP_SuppleOfferPrices|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \StructType\JPSOAP_SuppleOfferPrices $prices
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setPrices(\StructType\JPSOAP_SuppleOfferPrices $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get Allotment value
     * @return \ArrayType\ArrayOfJPSOAP_Allotment|null
     */
    public function getAllotment()
    {
        return $this->Allotment;
    }
    /**
     * Set Allotment value
     * @param \ArrayType\ArrayOfJPSOAP_Allotment $allotment
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setAllotment(\ArrayType\ArrayOfJPSOAP_Allotment $allotment = null)
    {
        $this->Allotment = $allotment;
        return $this;
    }
    /**
     * Get FreeNights value
     * @return \StructType\JPSOAP_HotelRatePlanFreeNightsOffer|null
     */
    public function getFreeNights()
    {
        return $this->FreeNights;
    }
    /**
     * Set FreeNights value
     * @param \StructType\JPSOAP_HotelRatePlanFreeNightsOffer $freeNights
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setFreeNights(\StructType\JPSOAP_HotelRatePlanFreeNightsOffer $freeNights = null)
    {
        $this->FreeNights = $freeNights;
        return $this;
    }
    /**
     * Get FreePaxes value
     * @return \StructType\JPSOAP_HotelRatePlanFreePaxesOffer|null
     */
    public function getFreePaxes()
    {
        return $this->FreePaxes;
    }
    /**
     * Set FreePaxes value
     * @param \StructType\JPSOAP_HotelRatePlanFreePaxesOffer $freePaxes
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setFreePaxes(\StructType\JPSOAP_HotelRatePlanFreePaxesOffer $freePaxes = null)
    {
        $this->FreePaxes = $freePaxes;
        return $this;
    }
    /**
     * Get BoardUpgrade value
     * @return \StructType\JPSOAP_HotelRatePlanBoardUpgradeOffer|null
     */
    public function getBoardUpgrade()
    {
        return $this->BoardUpgrade;
    }
    /**
     * Set BoardUpgrade value
     * @param \StructType\JPSOAP_HotelRatePlanBoardUpgradeOffer $boardUpgrade
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setBoardUpgrade(\StructType\JPSOAP_HotelRatePlanBoardUpgradeOffer $boardUpgrade = null)
    {
        $this->BoardUpgrade = $boardUpgrade;
        return $this;
    }
    /**
     * Get RoomUpgrade value
     * @return \StructType\JPSOAP_HotelRatePlanRoomUpgradeOffer|null
     */
    public function getRoomUpgrade()
    {
        return $this->RoomUpgrade;
    }
    /**
     * Set RoomUpgrade value
     * @param \StructType\JPSOAP_HotelRatePlanRoomUpgradeOffer $roomUpgrade
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setRoomUpgrade(\StructType\JPSOAP_HotelRatePlanRoomUpgradeOffer $roomUpgrade = null)
    {
        $this->RoomUpgrade = $roomUpgrade;
        return $this;
    }
    /**
     * Get PaymentConditions value
     * @return \StructType\JPSOAP_HotelRatePlanOfferPaymentConditions|null
     */
    public function getPaymentConditions()
    {
        return $this->PaymentConditions;
    }
    /**
     * Set PaymentConditions value
     * @param \StructType\JPSOAP_HotelRatePlanOfferPaymentConditions $paymentConditions
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setPaymentConditions(\StructType\JPSOAP_HotelRatePlanOfferPaymentConditions $paymentConditions = null)
    {
        $this->PaymentConditions = $paymentConditions;
        return $this;
    }
    /**
     * Get PromoCode value
     * @return string|null
     */
    public function getPromoCode()
    {
        return $this->PromoCode;
    }
    /**
     * Set PromoCode value
     * @param string $promoCode
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        $this->PromoCode = $promoCode;
        return $this;
    }
    /**
     * Get MandatoryPromoCode value
     * @return bool|null
     */
    public function getMandatoryPromoCode()
    {
        return $this->MandatoryPromoCode;
    }
    /**
     * Set MandatoryPromoCode value
     * @param bool $mandatoryPromoCode
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setMandatoryPromoCode($mandatoryPromoCode = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryPromoCode) && !is_bool($mandatoryPromoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryPromoCode, true), gettype($mandatoryPromoCode)), __LINE__);
        }
        $this->MandatoryPromoCode = $mandatoryPromoCode;
        return $this;
    }
    /**
     * Get BaseBoardCode value
     * @return int|null
     */
    public function getBaseBoardCode()
    {
        return $this->BaseBoardCode;
    }
    /**
     * Set BaseBoardCode value
     * @param int $baseBoardCode
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setBaseBoardCode($baseBoardCode = null)
    {
        // validation for constraint: int
        if (!is_null($baseBoardCode) && !(is_int($baseBoardCode) || ctype_digit($baseBoardCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baseBoardCode, true), gettype($baseBoardCode)), __LINE__);
        }
        $this->BaseBoardCode = $baseBoardCode;
        return $this;
    }
    /**
     * Get SeasonOrder value
     * @return int|null
     */
    public function getSeasonOrder()
    {
        return $this->SeasonOrder;
    }
    /**
     * Set SeasonOrder value
     * @param int $seasonOrder
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public function setSeasonOrder($seasonOrder = null)
    {
        // validation for constraint: int
        if (!is_null($seasonOrder) && !(is_int($seasonOrder) || ctype_digit($seasonOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seasonOrder, true), gettype($seasonOrder)), __LINE__);
        }
        $this->SeasonOrder = $seasonOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_HotelRatePlanOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
