<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_PriceFrom ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_PriceFrom extends AbstractStructArrayBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PriceFrom[]
     */
    public $Price;
    /**
     * Constructor method for ArrayOfJP_PriceFrom
     * @uses ArrayOfJP_PriceFrom::setPrice()
     * @param \StructType\JP_PriceFrom[] $price
     */
    public function __construct(array $price = array())
    {
        $this
            ->setPrice($price);
    }
    /**
     * Get Price value
     * @return \StructType\JP_PriceFrom[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_PriceFromPriceItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_PriceFromPriceItem instanceof \StructType\JP_PriceFrom) {
                $invalidValues[] = is_object($arrayOfJP_PriceFromPriceItem) ? get_class($arrayOfJP_PriceFromPriceItem) : sprintf('%s(%s)', gettype($arrayOfJP_PriceFromPriceItem), var_export($arrayOfJP_PriceFromPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Price property can only contain items of type \StructType\JP_PriceFrom, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PriceFrom[] $price
     * @return \ArrayType\ArrayOfJP_PriceFrom
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PriceFrom $item
     * @return \ArrayType\ArrayOfJP_PriceFrom
     */
    public function addToPrice(\StructType\JP_PriceFrom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PriceFrom) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of type \StructType\JP_PriceFrom, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_PriceFrom|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_PriceFrom|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_PriceFrom|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_PriceFrom|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_PriceFrom|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Price
     */
    public function getAttributeName()
    {
        return 'Price';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_PriceFrom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
