<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_HotelRatePlanOfferPaymentConditions StructType
 * @subpackage Structs
 */
class JPSOAP_HotelRatePlanOfferPaymentConditions extends AbstractStructBase
{
    /**
     * The PaymentDate
     * @var string
     */
    public $PaymentDate;
    /**
     * The Percentage
     * @var float
     */
    public $Percentage;
    /**
     * Constructor method for JPSOAP_HotelRatePlanOfferPaymentConditions
     * @uses JPSOAP_HotelRatePlanOfferPaymentConditions::setPaymentDate()
     * @uses JPSOAP_HotelRatePlanOfferPaymentConditions::setPercentage()
     * @param string $paymentDate
     * @param float $percentage
     */
    public function __construct($paymentDate = null, $percentage = null)
    {
        $this
            ->setPaymentDate($paymentDate)
            ->setPercentage($percentage);
    }
    /**
     * Get PaymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\JPSOAP_HotelRatePlanOfferPaymentConditions
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\JPSOAP_HotelRatePlanOfferPaymentConditions
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: float
        if (!is_null($percentage) && !(is_float($percentage) || is_numeric($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_HotelRatePlanOfferPaymentConditions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
