<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_VisaPortfolioRQ StructType
 * @subpackage Structs
 */
class JP_VisaPortfolioRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The RestrictedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Page
     * @var int
     */
    public $Page;
    /**
     * The RecordsPerPage
     * @var int
     */
    public $RecordsPerPage;
    /**
     * Constructor method for JP_VisaPortfolioRQ
     * @uses JP_VisaPortfolioRQ::setLogin()
     * @uses JP_VisaPortfolioRQ::setRestrictedOptions()
     * @uses JP_VisaPortfolioRQ::setVersion()
     * @uses JP_VisaPortfolioRQ::setLanguage()
     * @uses JP_VisaPortfolioRQ::setPage()
     * @uses JP_VisaPortfolioRQ::setRecordsPerPage()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     * @param int $page
     * @param int $recordsPerPage
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null, $page = null, $recordsPerPage = null)
    {
        $this
            ->setLogin($login)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language)
            ->setPage($page)
            ->setRecordsPerPage($recordsPerPage);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_VisaPortfolioRQ
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_VisaPortfolioRQ
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_VisaPortfolioRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_VisaPortfolioRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Page value
     * @return int|null
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param int $page
     * @return \StructType\JP_VisaPortfolioRQ
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !(is_int($page) || ctype_digit($page))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get RecordsPerPage value
     * @return int|null
     */
    public function getRecordsPerPage()
    {
        return $this->RecordsPerPage;
    }
    /**
     * Set RecordsPerPage value
     * @param int $recordsPerPage
     * @return \StructType\JP_VisaPortfolioRQ
     */
    public function setRecordsPerPage($recordsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($recordsPerPage) && !(is_int($recordsPerPage) || ctype_digit($recordsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordsPerPage, true), gettype($recordsPerPage)), __LINE__);
        }
        $this->RecordsPerPage = $recordsPerPage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_VisaPortfolioRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
