<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PaymentRQ StructType
 * @subpackage Structs
 */
class JP_PaymentRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The PaymentRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PaymentRequest
     */
    public $PaymentRequest;
    /**
     * The RestrictedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The ExtraParams
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RequiredField
     */
    public $ExtraParams;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for JP_PaymentRQ
     * @uses JP_PaymentRQ::setLogin()
     * @uses JP_PaymentRQ::setPaymentRequest()
     * @uses JP_PaymentRQ::setRestrictedOptions()
     * @uses JP_PaymentRQ::setExtraParams()
     * @uses JP_PaymentRQ::setVersion()
     * @uses JP_PaymentRQ::setLanguage()
     * @uses JP_PaymentRQ::setTimeStamp()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_PaymentRequest $paymentRequest
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param \ArrayType\ArrayOfJP_RequiredField $extraParams
     * @param string $version
     * @param string $language
     * @param string $timeStamp
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_PaymentRequest $paymentRequest = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, \ArrayType\ArrayOfJP_RequiredField $extraParams = null, $version = null, $language = null, $timeStamp = null)
    {
        $this
            ->setLogin($login)
            ->setPaymentRequest($paymentRequest)
            ->setRestrictedOptions($restrictedOptions)
            ->setExtraParams($extraParams)
            ->setVersion($version)
            ->setLanguage($language)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_PaymentRQ
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get PaymentRequest value
     * @return \StructType\JP_PaymentRequest|null
     */
    public function getPaymentRequest()
    {
        return $this->PaymentRequest;
    }
    /**
     * Set PaymentRequest value
     * @param \StructType\JP_PaymentRequest $paymentRequest
     * @return \StructType\JP_PaymentRQ
     */
    public function setPaymentRequest(\StructType\JP_PaymentRequest $paymentRequest = null)
    {
        $this->PaymentRequest = $paymentRequest;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_PaymentRQ
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get ExtraParams value
     * @return \ArrayType\ArrayOfJP_RequiredField|null
     */
    public function getExtraParams()
    {
        return $this->ExtraParams;
    }
    /**
     * Set ExtraParams value
     * @param \ArrayType\ArrayOfJP_RequiredField $extraParams
     * @return \StructType\JP_PaymentRQ
     */
    public function setExtraParams(\ArrayType\ArrayOfJP_RequiredField $extraParams = null)
    {
        $this->ExtraParams = $extraParams;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_PaymentRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_PaymentRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_PaymentRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PaymentRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
