<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelItem StructType
 * @subpackage Structs
 */
class JP_HotelItem extends JP_BaseItem
{
    /**
     * The HotelInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ItemHotelInfo
     */
    public $HotelInfo;
    /**
     * The Board
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Board
     */
    public $Board;
    /**
     * The HotelRooms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ItemHotelRoom
     */
    public $HotelRooms;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Supplier
     */
    public $Supplier;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The PaymentDestination
     * @var bool
     */
    public $PaymentDestination;
    /**
     * Constructor method for JP_HotelItem
     * @uses JP_HotelItem::setHotelInfo()
     * @uses JP_HotelItem::setBoard()
     * @uses JP_HotelItem::setHotelRooms()
     * @uses JP_HotelItem::setAdditionalElements()
     * @uses JP_HotelItem::setSupplier()
     * @uses JP_HotelItem::setStart()
     * @uses JP_HotelItem::setEnd()
     * @uses JP_HotelItem::setPaymentDestination()
     * @param \StructType\JP_ItemHotelInfo $hotelInfo
     * @param \StructType\JP_Board $board
     * @param \ArrayType\ArrayOfJP_ItemHotelRoom $hotelRooms
     * @param \StructType\JP_HotelAdditionalElements $additionalElements
     * @param \StructType\JP_Supplier $supplier
     * @param string $start
     * @param string $end
     * @param bool $paymentDestination
     */
    public function __construct(\StructType\JP_ItemHotelInfo $hotelInfo = null, \StructType\JP_Board $board = null, \ArrayType\ArrayOfJP_ItemHotelRoom $hotelRooms = null, \StructType\JP_HotelAdditionalElements $additionalElements = null, \StructType\JP_Supplier $supplier = null, $start = null, $end = null, $paymentDestination = null)
    {
        $this
            ->setHotelInfo($hotelInfo)
            ->setBoard($board)
            ->setHotelRooms($hotelRooms)
            ->setAdditionalElements($additionalElements)
            ->setSupplier($supplier)
            ->setStart($start)
            ->setEnd($end)
            ->setPaymentDestination($paymentDestination);
    }
    /**
     * Get HotelInfo value
     * @return \StructType\JP_ItemHotelInfo|null
     */
    public function getHotelInfo()
    {
        return $this->HotelInfo;
    }
    /**
     * Set HotelInfo value
     * @param \StructType\JP_ItemHotelInfo $hotelInfo
     * @return \StructType\JP_HotelItem
     */
    public function setHotelInfo(\StructType\JP_ItemHotelInfo $hotelInfo = null)
    {
        $this->HotelInfo = $hotelInfo;
        return $this;
    }
    /**
     * Get Board value
     * @return \StructType\JP_Board|null
     */
    public function getBoard()
    {
        return $this->Board;
    }
    /**
     * Set Board value
     * @param \StructType\JP_Board $board
     * @return \StructType\JP_HotelItem
     */
    public function setBoard(\StructType\JP_Board $board = null)
    {
        $this->Board = $board;
        return $this;
    }
    /**
     * Get HotelRooms value
     * @return \ArrayType\ArrayOfJP_ItemHotelRoom|null
     */
    public function getHotelRooms()
    {
        return $this->HotelRooms;
    }
    /**
     * Set HotelRooms value
     * @param \ArrayType\ArrayOfJP_ItemHotelRoom $hotelRooms
     * @return \StructType\JP_HotelItem
     */
    public function setHotelRooms(\ArrayType\ArrayOfJP_ItemHotelRoom $hotelRooms = null)
    {
        $this->HotelRooms = $hotelRooms;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_HotelAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_HotelAdditionalElements $additionalElements
     * @return \StructType\JP_HotelItem
     */
    public function setAdditionalElements(\StructType\JP_HotelAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get Supplier value
     * @return \StructType\JP_Supplier|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param \StructType\JP_Supplier $supplier
     * @return \StructType\JP_HotelItem
     */
    public function setSupplier(\StructType\JP_Supplier $supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_HotelItem
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_HotelItem
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get PaymentDestination value
     * @return bool|null
     */
    public function getPaymentDestination()
    {
        return $this->PaymentDestination;
    }
    /**
     * Set PaymentDestination value
     * @param bool $paymentDestination
     * @return \StructType\JP_HotelItem
     */
    public function setPaymentDestination($paymentDestination = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentDestination) && !is_bool($paymentDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentDestination, true), gettype($paymentDestination)), __LINE__);
        }
        $this->PaymentDestination = $paymentDestination;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
