<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_HotelPreference ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_HotelPreference extends AbstractStructArrayBase
{
    /**
     * The Preference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelPreference[]
     */
    public $Preference;
    /**
     * Constructor method for ArrayOfJP_HotelPreference
     * @uses ArrayOfJP_HotelPreference::setPreference()
     * @param \StructType\JP_HotelPreference[] $preference
     */
    public function __construct(array $preference = array())
    {
        $this
            ->setPreference($preference);
    }
    /**
     * Get Preference value
     * @return \StructType\JP_HotelPreference[]|null
     */
    public function getPreference()
    {
        return $this->Preference;
    }
    /**
     * This method is responsible for validating the values passed to the setPreference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePreferenceForArrayConstraintsFromSetPreference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_HotelPreferencePreferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_HotelPreferencePreferenceItem instanceof \StructType\JP_HotelPreference) {
                $invalidValues[] = is_object($arrayOfJP_HotelPreferencePreferenceItem) ? get_class($arrayOfJP_HotelPreferencePreferenceItem) : sprintf('%s(%s)', gettype($arrayOfJP_HotelPreferencePreferenceItem), var_export($arrayOfJP_HotelPreferencePreferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Preference property can only contain items of type \StructType\JP_HotelPreference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Preference value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelPreference[] $preference
     * @return \ArrayType\ArrayOfJP_HotelPreference
     */
    public function setPreference(array $preference = array())
    {
        // validation for constraint: array
        if ('' !== ($preferenceArrayErrorMessage = self::validatePreferenceForArrayConstraintsFromSetPreference($preference))) {
            throw new \InvalidArgumentException($preferenceArrayErrorMessage, __LINE__);
        }
        $this->Preference = $preference;
        return $this;
    }
    /**
     * Add item to Preference value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelPreference $item
     * @return \ArrayType\ArrayOfJP_HotelPreference
     */
    public function addToPreference(\StructType\JP_HotelPreference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelPreference) {
            throw new \InvalidArgumentException(sprintf('The Preference property can only contain items of type \StructType\JP_HotelPreference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Preference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_HotelPreference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_HotelPreference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_HotelPreference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_HotelPreference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_HotelPreference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Preference
     */
    public function getAttributeName()
    {
        return 'Preference';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_HotelPreference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
