<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageContent StructType
 * @subpackage Structs
 */
class JP_PackageContent extends AbstractStructBase
{
    /**
     * The PackageName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackageName;
    /**
     * The Origins
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageZone
     */
    public $Origins;
    /**
     * The Destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageZone
     */
    public $Destinations;
    /**
     * The StayDestinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageZone
     */
    public $StayDestinations;
    /**
     * The Dates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageDate
     */
    public $Dates;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PriceFrom
     */
    public $Prices;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Images;
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Description
     */
    public $Descriptions;
    /**
     * The Itineraries
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_PackageItinerary
     */
    public $Itineraries;
    /**
     * The PackageCalendarPriceItems
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PackageCalendarPriceItems[]
     */
    public $PackageCalendarPriceItems;
    /**
     * The ProductTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ProductType
     */
    public $ProductTypes;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The Master
     * @var bool
     */
    public $Master;
    /**
     * Constructor method for JP_PackageContent
     * @uses JP_PackageContent::setPackageName()
     * @uses JP_PackageContent::setOrigins()
     * @uses JP_PackageContent::setDestinations()
     * @uses JP_PackageContent::setStayDestinations()
     * @uses JP_PackageContent::setDates()
     * @uses JP_PackageContent::setPrices()
     * @uses JP_PackageContent::setImages()
     * @uses JP_PackageContent::setDescriptions()
     * @uses JP_PackageContent::setItineraries()
     * @uses JP_PackageContent::setPackageCalendarPriceItems()
     * @uses JP_PackageContent::setProductTypes()
     * @uses JP_PackageContent::setCode()
     * @uses JP_PackageContent::setDuration()
     * @uses JP_PackageContent::setMaster()
     * @param string $packageName
     * @param \ArrayType\ArrayOfJP_PackageZone $origins
     * @param \ArrayType\ArrayOfJP_PackageZone $destinations
     * @param \ArrayType\ArrayOfJP_PackageZone $stayDestinations
     * @param \ArrayType\ArrayOfJP_PackageDate $dates
     * @param \ArrayType\ArrayOfJP_PriceFrom $prices
     * @param \ArrayType\ArrayOfString1 $images
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @param \ArrayType\ArrayOfJP_PackageItinerary $itineraries
     * @param \StructType\JP_PackageCalendarPriceItems[] $packageCalendarPriceItems
     * @param \ArrayType\ArrayOfJP_ProductType $productTypes
     * @param string $code
     * @param string $duration
     * @param bool $master
     */
    public function __construct($packageName = null, \ArrayType\ArrayOfJP_PackageZone $origins = null, \ArrayType\ArrayOfJP_PackageZone $destinations = null, \ArrayType\ArrayOfJP_PackageZone $stayDestinations = null, \ArrayType\ArrayOfJP_PackageDate $dates = null, \ArrayType\ArrayOfJP_PriceFrom $prices = null, \ArrayType\ArrayOfString1 $images = null, \ArrayType\ArrayOfJP_Description $descriptions = null, \ArrayType\ArrayOfJP_PackageItinerary $itineraries = null, array $packageCalendarPriceItems = array(), \ArrayType\ArrayOfJP_ProductType $productTypes = null, $code = null, $duration = null, $master = null)
    {
        $this
            ->setPackageName($packageName)
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setStayDestinations($stayDestinations)
            ->setDates($dates)
            ->setPrices($prices)
            ->setImages($images)
            ->setDescriptions($descriptions)
            ->setItineraries($itineraries)
            ->setPackageCalendarPriceItems($packageCalendarPriceItems)
            ->setProductTypes($productTypes)
            ->setCode($code)
            ->setDuration($duration)
            ->setMaster($master);
    }
    /**
     * Get PackageName value
     * @return string|null
     */
    public function getPackageName()
    {
        return $this->PackageName;
    }
    /**
     * Set PackageName value
     * @param string $packageName
     * @return \StructType\JP_PackageContent
     */
    public function setPackageName($packageName = null)
    {
        // validation for constraint: string
        if (!is_null($packageName) && !is_string($packageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageName, true), gettype($packageName)), __LINE__);
        }
        $this->PackageName = $packageName;
        return $this;
    }
    /**
     * Get Origins value
     * @return \ArrayType\ArrayOfJP_PackageZone|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @param \ArrayType\ArrayOfJP_PackageZone $origins
     * @return \StructType\JP_PackageContent
     */
    public function setOrigins(\ArrayType\ArrayOfJP_PackageZone $origins = null)
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \ArrayType\ArrayOfJP_PackageZone|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \ArrayType\ArrayOfJP_PackageZone $destinations
     * @return \StructType\JP_PackageContent
     */
    public function setDestinations(\ArrayType\ArrayOfJP_PackageZone $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get StayDestinations value
     * @return \ArrayType\ArrayOfJP_PackageZone|null
     */
    public function getStayDestinations()
    {
        return $this->StayDestinations;
    }
    /**
     * Set StayDestinations value
     * @param \ArrayType\ArrayOfJP_PackageZone $stayDestinations
     * @return \StructType\JP_PackageContent
     */
    public function setStayDestinations(\ArrayType\ArrayOfJP_PackageZone $stayDestinations = null)
    {
        $this->StayDestinations = $stayDestinations;
        return $this;
    }
    /**
     * Get Dates value
     * @return \ArrayType\ArrayOfJP_PackageDate|null
     */
    public function getDates()
    {
        return $this->Dates;
    }
    /**
     * Set Dates value
     * @param \ArrayType\ArrayOfJP_PackageDate $dates
     * @return \StructType\JP_PackageContent
     */
    public function setDates(\ArrayType\ArrayOfJP_PackageDate $dates = null)
    {
        $this->Dates = $dates;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_PriceFrom|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_PriceFrom $prices
     * @return \StructType\JP_PackageContent
     */
    public function setPrices(\ArrayType\ArrayOfJP_PriceFrom $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString1 $images
     * @return \StructType\JP_PackageContent
     */
    public function setImages(\ArrayType\ArrayOfString1 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \ArrayType\ArrayOfJP_Description|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @return \StructType\JP_PackageContent
     */
    public function setDescriptions(\ArrayType\ArrayOfJP_Description $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get Itineraries value
     * @return \ArrayType\ArrayOfJP_PackageItinerary|null
     */
    public function getItineraries()
    {
        return $this->Itineraries;
    }
    /**
     * Set Itineraries value
     * @param \ArrayType\ArrayOfJP_PackageItinerary $itineraries
     * @return \StructType\JP_PackageContent
     */
    public function setItineraries(\ArrayType\ArrayOfJP_PackageItinerary $itineraries = null)
    {
        $this->Itineraries = $itineraries;
        return $this;
    }
    /**
     * Get PackageCalendarPriceItems value
     * @return \StructType\JP_PackageCalendarPriceItems[]|null
     */
    public function getPackageCalendarPriceItems()
    {
        return $this->PackageCalendarPriceItems;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageCalendarPriceItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageCalendarPriceItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageCalendarPriceItemsForArrayConstraintsFromSetPackageCalendarPriceItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_PackageContentPackageCalendarPriceItemsItem) {
            // validation for constraint: itemType
            if (!$jP_PackageContentPackageCalendarPriceItemsItem instanceof \StructType\JP_PackageCalendarPriceItems) {
                $invalidValues[] = is_object($jP_PackageContentPackageCalendarPriceItemsItem) ? get_class($jP_PackageContentPackageCalendarPriceItemsItem) : sprintf('%s(%s)', gettype($jP_PackageContentPackageCalendarPriceItemsItem), var_export($jP_PackageContentPackageCalendarPriceItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageCalendarPriceItems property can only contain items of type \StructType\JP_PackageCalendarPriceItems, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageCalendarPriceItems value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageCalendarPriceItems[] $packageCalendarPriceItems
     * @return \StructType\JP_PackageContent
     */
    public function setPackageCalendarPriceItems(array $packageCalendarPriceItems = array())
    {
        // validation for constraint: array
        if ('' !== ($packageCalendarPriceItemsArrayErrorMessage = self::validatePackageCalendarPriceItemsForArrayConstraintsFromSetPackageCalendarPriceItems($packageCalendarPriceItems))) {
            throw new \InvalidArgumentException($packageCalendarPriceItemsArrayErrorMessage, __LINE__);
        }
        $this->PackageCalendarPriceItems = $packageCalendarPriceItems;
        return $this;
    }
    /**
     * Add item to PackageCalendarPriceItems value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageCalendarPriceItems $item
     * @return \StructType\JP_PackageContent
     */
    public function addToPackageCalendarPriceItems(\StructType\JP_PackageCalendarPriceItems $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PackageCalendarPriceItems) {
            throw new \InvalidArgumentException(sprintf('The PackageCalendarPriceItems property can only contain items of type \StructType\JP_PackageCalendarPriceItems, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageCalendarPriceItems[] = $item;
        return $this;
    }
    /**
     * Get ProductTypes value
     * @return \ArrayType\ArrayOfJP_ProductType|null
     */
    public function getProductTypes()
    {
        return $this->ProductTypes;
    }
    /**
     * Set ProductTypes value
     * @param \ArrayType\ArrayOfJP_ProductType $productTypes
     * @return \StructType\JP_PackageContent
     */
    public function setProductTypes(\ArrayType\ArrayOfJP_ProductType $productTypes = null)
    {
        $this->ProductTypes = $productTypes;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_PackageContent
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\JP_PackageContent
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Master value
     * @return bool|null
     */
    public function getMaster()
    {
        return $this->Master;
    }
    /**
     * Set Master value
     * @param bool $master
     * @return \StructType\JP_PackageContent
     */
    public function setMaster($master = null)
    {
        // validation for constraint: boolean
        if (!is_null($master) && !is_bool($master)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($master, true), gettype($master)), __LINE__);
        }
        $this->Master = $master;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PackageContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
