<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelCalendarResult StructType
 * @subpackage Structs
 */
class JP_HotelCalendarResult extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The HotelResults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelResult
     */
    public $HotelResults;
    /**
     * Constructor method for JP_HotelCalendarResult
     * @uses JP_HotelCalendarResult::setStart()
     * @uses JP_HotelCalendarResult::setEnd()
     * @uses JP_HotelCalendarResult::setHotelResults()
     * @param string $start
     * @param string $end
     * @param \ArrayType\ArrayOfJP_HotelResult $hotelResults
     */
    public function __construct($start = null, $end = null, \ArrayType\ArrayOfJP_HotelResult $hotelResults = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setHotelResults($hotelResults);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_HotelCalendarResult
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_HotelCalendarResult
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get HotelResults value
     * @return \ArrayType\ArrayOfJP_HotelResult|null
     */
    public function getHotelResults()
    {
        return $this->HotelResults;
    }
    /**
     * Set HotelResults value
     * @param \ArrayType\ArrayOfJP_HotelResult $hotelResults
     * @return \StructType\JP_HotelCalendarResult
     */
    public function setHotelResults(\ArrayType\ArrayOfJP_HotelResult $hotelResults = null)
    {
        $this->HotelResults = $hotelResults;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelCalendarResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
