<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_ApplicationRulesSupplement StructType
 * @subpackage Structs
 */
class JPSOAP_ApplicationRulesSupplement extends JPSOAP_ApplicationRules
{
    /**
     * The AlternateWithSupplements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_IntCodeAttr1
     */
    public $AlternateWithSupplements;
    /**
     * The CalculationBySeason
     * @var string
     */
    public $CalculationBySeason;
    /**
     * Constructor method for JPSOAP_ApplicationRulesSupplement
     * @uses JPSOAP_ApplicationRulesSupplement::setAlternateWithSupplements()
     * @uses JPSOAP_ApplicationRulesSupplement::setCalculationBySeason()
     * @param \ArrayType\ArrayOfJPSOAP_IntCodeAttr1 $alternateWithSupplements
     * @param string $calculationBySeason
     */
    public function __construct(\ArrayType\ArrayOfJPSOAP_IntCodeAttr1 $alternateWithSupplements = null, $calculationBySeason = null)
    {
        $this
            ->setAlternateWithSupplements($alternateWithSupplements)
            ->setCalculationBySeason($calculationBySeason);
    }
    /**
     * Get AlternateWithSupplements value
     * @return \ArrayType\ArrayOfJPSOAP_IntCodeAttr1|null
     */
    public function getAlternateWithSupplements()
    {
        return $this->AlternateWithSupplements;
    }
    /**
     * Set AlternateWithSupplements value
     * @param \ArrayType\ArrayOfJPSOAP_IntCodeAttr1 $alternateWithSupplements
     * @return \StructType\JPSOAP_ApplicationRulesSupplement
     */
    public function setAlternateWithSupplements(\ArrayType\ArrayOfJPSOAP_IntCodeAttr1 $alternateWithSupplements = null)
    {
        $this->AlternateWithSupplements = $alternateWithSupplements;
        return $this;
    }
    /**
     * Get CalculationBySeason value
     * @return string|null
     */
    public function getCalculationBySeason()
    {
        return $this->CalculationBySeason;
    }
    /**
     * Set CalculationBySeason value
     * @uses \EnumType\JPSOAP_CalculationBySeason::valueIsValid()
     * @uses \EnumType\JPSOAP_CalculationBySeason::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calculationBySeason
     * @return \StructType\JPSOAP_ApplicationRulesSupplement
     */
    public function setCalculationBySeason($calculationBySeason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_CalculationBySeason::valueIsValid($calculationBySeason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JPSOAP_CalculationBySeason', is_array($calculationBySeason) ? implode(', ', $calculationBySeason) : var_export($calculationBySeason, true), implode(', ', \EnumType\JPSOAP_CalculationBySeason::getValidValues())), __LINE__);
        }
        $this->CalculationBySeason = $calculationBySeason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_ApplicationRulesSupplement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
