<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transfer ServiceType
 * @subpackage Services
 */
class Transfer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TransferBooking
     * Meta information extracted from the WSDL
     * - documentation: Booking for transfers.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferBooking $parameters
     * @return \StructType\TransferBookingResponse|bool
     */
    public function TransferBooking(\StructType\TransferBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransferAvail
     * Meta information extracted from the WSDL
     * - documentation: Availability for transfers.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferAvail $parameters
     * @return \StructType\TransferAvailResponse|bool
     */
    public function TransferAvail(\StructType\TransferAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransferAvailByHotel
     * Meta information extracted from the WSDL
     * - documentation: Availability for transfers.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferAvailByHotel $parameters
     * @return \StructType\TransferAvailByHotelResponse|bool
     */
    public function TransferAvailByHotel(\StructType\TransferAvailByHotel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferAvailByHotel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransferPortfolio
     * Meta information extracted from the WSDL
     * - documentation: Paged Portfolio of Transfers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferPortfolio $parameters
     * @return \StructType\TransferPortfolioResponse|bool
     */
    public function TransferPortfolio(\StructType\TransferPortfolio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferPortfolio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransferCatalogueData
     * Meta information extracted from the WSDL
     * - documentation: Catalogue For Transfers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferCatalogueData $parameters
     * @return \StructType\TransferCatalogueDataResponse|bool
     */
    public function TransferCatalogueData(\StructType\TransferCatalogueData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferCatalogueData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransferContent
     * Meta information extracted from the WSDL
     * - documentation: Content Of Transfers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferContent $parameters
     * @return \StructType\TransferContentResponse|bool
     */
    public function TransferContent(\StructType\TransferContent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransferCheckAvail
     * Meta information extracted from the WSDL
     * - documentation: CheckAvail for transfers.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferCheckAvail $parameters
     * @return \StructType\TransferCheckAvailResponse|bool
     */
    public function TransferCheckAvail(\StructType\TransferCheckAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransferBookingRules
     * Meta information extracted from the WSDL
     * - documentation: BookingRules Of transfers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransferBookingRules $parameters
     * @return \StructType\TransferBookingRulesResponse|bool
     */
    public function TransferBookingRules(\StructType\TransferBookingRules $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransferBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TransferAvailByHotelResponse|\StructType\TransferAvailResponse|\StructType\TransferBookingResponse|\StructType\TransferBookingRulesResponse|\StructType\TransferCatalogueDataResponse|\StructType\TransferCheckAvailResponse|\StructType\TransferContentResponse|\StructType\TransferPortfolioResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
