<?php

namespace EnumType;

/**
 * This class stands for PaymentType EnumType
 * @subpackage Enumerations
 */
class PaymentType
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'ExcludePaymentInDestination'
     * @return string 'ExcludePaymentInDestination'
     */
    const VALUE_EXCLUDE_PAYMENT_IN_DESTINATION = 'ExcludePaymentInDestination';
    /**
     * Constant for value 'OnlyPaymentInDestination'
     * @return string 'OnlyPaymentInDestination'
     */
    const VALUE_ONLY_PAYMENT_IN_DESTINATION = 'OnlyPaymentInDestination';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_EXCLUDE_PAYMENT_IN_DESTINATION
     * @uses self::VALUE_ONLY_PAYMENT_IN_DESTINATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_EXCLUDE_PAYMENT_IN_DESTINATION,
            self::VALUE_ONLY_PAYMENT_IN_DESTINATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
