<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ImageLong ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ImageLong extends AbstractStructArrayBase
{
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ImageLong[]
     */
    public $Image;
    /**
     * Constructor method for ArrayOfJP_ImageLong
     * @uses ArrayOfJP_ImageLong::setImage()
     * @param \StructType\JP_ImageLong[] $image
     */
    public function __construct(array $image = array())
    {
        $this
            ->setImage($image);
    }
    /**
     * Get Image value
     * @return \StructType\JP_ImageLong[]|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * This method is responsible for validating the values passed to the setImage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageForArrayConstraintsFromSetImage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_ImageLongImageItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ImageLongImageItem instanceof \StructType\JP_ImageLong) {
                $invalidValues[] = is_object($arrayOfJP_ImageLongImageItem) ? get_class($arrayOfJP_ImageLongImageItem) : sprintf('%s(%s)', gettype($arrayOfJP_ImageLongImageItem), var_export($arrayOfJP_ImageLongImageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Image property can only contain items of type \StructType\JP_ImageLong, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Image value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ImageLong[] $image
     * @return \ArrayType\ArrayOfJP_ImageLong
     */
    public function setImage(array $image = array())
    {
        // validation for constraint: array
        if ('' !== ($imageArrayErrorMessage = self::validateImageForArrayConstraintsFromSetImage($image))) {
            throw new \InvalidArgumentException($imageArrayErrorMessage, __LINE__);
        }
        $this->Image = $image;
        return $this;
    }
    /**
     * Add item to Image value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ImageLong $item
     * @return \ArrayType\ArrayOfJP_ImageLong
     */
    public function addToImage(\StructType\JP_ImageLong $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ImageLong) {
            throw new \InvalidArgumentException(sprintf('The Image property can only contain items of type \StructType\JP_ImageLong, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Image[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ImageLong|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ImageLong|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ImageLong|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ImageLong|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ImageLong|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Image
     */
    public function getAttributeName()
    {
        return 'Image';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_ImageLong
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
