<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Card ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Card extends AbstractStructArrayBase
{
    /**
     * The Card
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Card[]
     */
    public $Card;
    /**
     * Constructor method for ArrayOfJP_Card
     * @uses ArrayOfJP_Card::setCard()
     * @param \StructType\JP_Card[] $card
     */
    public function __construct(array $card = array())
    {
        $this
            ->setCard($card);
    }
    /**
     * Get Card value
     * @return \StructType\JP_Card[]|null
     */
    public function getCard()
    {
        return $this->Card;
    }
    /**
     * This method is responsible for validating the values passed to the setCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCardForArrayConstraintsFromSetCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_CardCardItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CardCardItem instanceof \StructType\JP_Card) {
                $invalidValues[] = is_object($arrayOfJP_CardCardItem) ? get_class($arrayOfJP_CardCardItem) : sprintf('%s(%s)', gettype($arrayOfJP_CardCardItem), var_export($arrayOfJP_CardCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Card property can only contain items of type \StructType\JP_Card, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Card value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Card[] $card
     * @return \ArrayType\ArrayOfJP_Card
     */
    public function setCard(array $card = array())
    {
        // validation for constraint: array
        if ('' !== ($cardArrayErrorMessage = self::validateCardForArrayConstraintsFromSetCard($card))) {
            throw new \InvalidArgumentException($cardArrayErrorMessage, __LINE__);
        }
        $this->Card = $card;
        return $this;
    }
    /**
     * Add item to Card value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Card $item
     * @return \ArrayType\ArrayOfJP_Card
     */
    public function addToCard(\StructType\JP_Card $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Card) {
            throw new \InvalidArgumentException(sprintf('The Card property can only contain items of type \StructType\JP_Card, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Card[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Card|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Card|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Card|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Card|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Card|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Card
     */
    public function getAttributeName()
    {
        return 'Card';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Card
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
