<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJPSOAP_Occupancy ArrayType
 * @subpackage Arrays
 */
class ArrayOfJPSOAP_Occupancy extends AbstractStructArrayBase
{
    /**
     * The Occupancy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_Occupancy[]
     */
    public $Occupancy;
    /**
     * Constructor method for ArrayOfJPSOAP_Occupancy
     * @uses ArrayOfJPSOAP_Occupancy::setOccupancy()
     * @param \StructType\JPSOAP_Occupancy[] $occupancy
     */
    public function __construct(array $occupancy = array())
    {
        $this
            ->setOccupancy($occupancy);
    }
    /**
     * Get Occupancy value
     * @return \StructType\JPSOAP_Occupancy[]|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * This method is responsible for validating the values passed to the setOccupancy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOccupancy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOccupancyForArrayConstraintsFromSetOccupancy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJPSOAP_OccupancyOccupancyItem) {
            // validation for constraint: itemType
            if (!$arrayOfJPSOAP_OccupancyOccupancyItem instanceof \StructType\JPSOAP_Occupancy) {
                $invalidValues[] = is_object($arrayOfJPSOAP_OccupancyOccupancyItem) ? get_class($arrayOfJPSOAP_OccupancyOccupancyItem) : sprintf('%s(%s)', gettype($arrayOfJPSOAP_OccupancyOccupancyItem), var_export($arrayOfJPSOAP_OccupancyOccupancyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Occupancy property can only contain items of type \StructType\JPSOAP_Occupancy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_Occupancy[] $occupancy
     * @return \ArrayType\ArrayOfJPSOAP_Occupancy
     */
    public function setOccupancy(array $occupancy = array())
    {
        // validation for constraint: array
        if ('' !== ($occupancyArrayErrorMessage = self::validateOccupancyForArrayConstraintsFromSetOccupancy($occupancy))) {
            throw new \InvalidArgumentException($occupancyArrayErrorMessage, __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Add item to Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_Occupancy $item
     * @return \ArrayType\ArrayOfJPSOAP_Occupancy
     */
    public function addToOccupancy(\StructType\JPSOAP_Occupancy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_Occupancy) {
            throw new \InvalidArgumentException(sprintf('The Occupancy property can only contain items of type \StructType\JPSOAP_Occupancy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Occupancy[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JPSOAP_Occupancy|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JPSOAP_Occupancy|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JPSOAP_Occupancy|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JPSOAP_Occupancy|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JPSOAP_Occupancy|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Occupancy
     */
    public function getAttributeName()
    {
        return 'Occupancy';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJPSOAP_Occupancy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
