<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferRuleOptionRQ StructType
 * @subpackage Structs
 */
class JP_TransferRuleOptionRQ extends AbstractStructBase
{
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * Constructor method for JP_TransferRuleOptionRQ
     * @uses JP_TransferRuleOptionRQ::setRatePlanCode()
     * @uses JP_TransferRuleOptionRQ::setStartDate()
     * @param string $ratePlanCode
     * @param string $startDate
     */
    public function __construct($ratePlanCode = null, $startDate = null)
    {
        $this
            ->setRatePlanCode($ratePlanCode)
            ->setStartDate($startDate);
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_TransferRuleOptionRQ
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\JP_TransferRuleOptionRQ
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_TransferRuleOptionRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
