<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentShip StructType
 * @subpackage Structs
 */
class JP_SearchSegmentShip extends AbstractStructBase
{
    /**
     * The CountryOfResidence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryOfResidence;
    /**
     * The ShipCode
     * @var string
     */
    public $ShipCode;
    /**
     * The Zone
     * @var int
     */
    public $Zone;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The CruiseCode
     * @var string
     */
    public $CruiseCode;
    /**
     * Constructor method for JP_SearchSegmentShip
     * @uses JP_SearchSegmentShip::setCountryOfResidence()
     * @uses JP_SearchSegmentShip::setShipCode()
     * @uses JP_SearchSegmentShip::setZone()
     * @uses JP_SearchSegmentShip::setStart()
     * @uses JP_SearchSegmentShip::setEnd()
     * @uses JP_SearchSegmentShip::setDuration()
     * @uses JP_SearchSegmentShip::setCruiseCode()
     * @param string $countryOfResidence
     * @param string $shipCode
     * @param int $zone
     * @param string $start
     * @param string $end
     * @param string $duration
     * @param string $cruiseCode
     */
    public function __construct($countryOfResidence = null, $shipCode = null, $zone = null, $start = null, $end = null, $duration = null, $cruiseCode = null)
    {
        $this
            ->setCountryOfResidence($countryOfResidence)
            ->setShipCode($shipCode)
            ->setZone($zone)
            ->setStart($start)
            ->setEnd($end)
            ->setDuration($duration)
            ->setCruiseCode($cruiseCode);
    }
    /**
     * Get CountryOfResidence value
     * @return string|null
     */
    public function getCountryOfResidence()
    {
        return $this->CountryOfResidence;
    }
    /**
     * Set CountryOfResidence value
     * @param string $countryOfResidence
     * @return \StructType\JP_SearchSegmentShip
     */
    public function setCountryOfResidence($countryOfResidence = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfResidence) && !is_string($countryOfResidence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfResidence, true), gettype($countryOfResidence)), __LINE__);
        }
        $this->CountryOfResidence = $countryOfResidence;
        return $this;
    }
    /**
     * Get ShipCode value
     * @return string|null
     */
    public function getShipCode()
    {
        return $this->ShipCode;
    }
    /**
     * Set ShipCode value
     * @param string $shipCode
     * @return \StructType\JP_SearchSegmentShip
     */
    public function setShipCode($shipCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipCode) && !is_string($shipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipCode, true), gettype($shipCode)), __LINE__);
        }
        $this->ShipCode = $shipCode;
        return $this;
    }
    /**
     * Get Zone value
     * @return int|null
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \StructType\JP_SearchSegmentShip
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !(is_int($zone) || ctype_digit($zone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zone, true), gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_SearchSegmentShip
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_SearchSegmentShip
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @uses \EnumType\JP_CruiseDuration::valueIsValid()
     * @uses \EnumType\JP_CruiseDuration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $duration
     * @return \StructType\JP_SearchSegmentShip
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_CruiseDuration::valueIsValid($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_CruiseDuration', is_array($duration) ? implode(', ', $duration) : var_export($duration, true), implode(', ', \EnumType\JP_CruiseDuration::getValidValues())), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get CruiseCode value
     * @return string|null
     */
    public function getCruiseCode()
    {
        return $this->CruiseCode;
    }
    /**
     * Set CruiseCode value
     * @param string $cruiseCode
     * @return \StructType\JP_SearchSegmentShip
     */
    public function setCruiseCode($cruiseCode = null)
    {
        // validation for constraint: string
        if (!is_null($cruiseCode) && !is_string($cruiseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cruiseCode, true), gettype($cruiseCode)), __LINE__);
        }
        $this->CruiseCode = $cruiseCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_SearchSegmentShip
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
