<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseCheckAvailResult StructType
 * @subpackage Structs
 */
class JP_CruiseCheckAvailResult extends AbstractStructBase
{
    /**
     * The Sea
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sea;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Ship
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Ship
     */
    public $Ship;
    /**
     * The Itinerary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseItinerary
     */
    public $Itinerary;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Categories
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CruiseCategory
     */
    public $Categories;
    /**
     * The BookingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $BookingCode;
    /**
     * The CruiseRequiredFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseRequiredFields
     */
    public $CruiseRequiredFields;
    /**
     * The CancellationPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The CancellationPolicyCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicyCost;
    /**
     * The PriceInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruisePriceInformation
     */
    public $PriceInformation;
    /**
     * The RelPaxesDist
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPaxDist
     */
    public $RelPaxesDist;
    /**
     * The OptionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseOptionalElements
     */
    public $OptionalElements;
    /**
     * The CruiseCode
     * @var string
     */
    public $CruiseCode;
    /**
     * The Zone
     * @var int
     */
    public $Zone;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The DaysDuration
     * @var int
     */
    public $DaysDuration;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for JP_CruiseCheckAvailResult
     * @uses JP_CruiseCheckAvailResult::setSea()
     * @uses JP_CruiseCheckAvailResult::setName()
     * @uses JP_CruiseCheckAvailResult::setShip()
     * @uses JP_CruiseCheckAvailResult::setItinerary()
     * @uses JP_CruiseCheckAvailResult::setDescription()
     * @uses JP_CruiseCheckAvailResult::setCategories()
     * @uses JP_CruiseCheckAvailResult::setBookingCode()
     * @uses JP_CruiseCheckAvailResult::setCruiseRequiredFields()
     * @uses JP_CruiseCheckAvailResult::setCancellationPolicy()
     * @uses JP_CruiseCheckAvailResult::setCancellationPolicyCost()
     * @uses JP_CruiseCheckAvailResult::setPriceInformation()
     * @uses JP_CruiseCheckAvailResult::setRelPaxesDist()
     * @uses JP_CruiseCheckAvailResult::setOptionalElements()
     * @uses JP_CruiseCheckAvailResult::setCruiseCode()
     * @uses JP_CruiseCheckAvailResult::setZone()
     * @uses JP_CruiseCheckAvailResult::setStartDate()
     * @uses JP_CruiseCheckAvailResult::setDaysDuration()
     * @uses JP_CruiseCheckAvailResult::setRatePlanCode()
     * @uses JP_CruiseCheckAvailResult::setStatus()
     * @param string $sea
     * @param string $name
     * @param \StructType\JP_Ship $ship
     * @param \StructType\JP_CruiseItinerary $itinerary
     * @param string $description
     * @param \ArrayType\ArrayOfJP_CruiseCategory $categories
     * @param \StructType\JP_BookingCode $bookingCode
     * @param \StructType\JP_CruiseRequiredFields $cruiseRequiredFields
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @param \StructType\JP_CruisePriceInformation $priceInformation
     * @param \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist
     * @param \StructType\JP_CruiseOptionalElements $optionalElements
     * @param string $cruiseCode
     * @param int $zone
     * @param string $startDate
     * @param int $daysDuration
     * @param string $ratePlanCode
     * @param string $status
     */
    public function __construct($sea = null, $name = null, \StructType\JP_Ship $ship = null, \StructType\JP_CruiseItinerary $itinerary = null, $description = null, \ArrayType\ArrayOfJP_CruiseCategory $categories = null, \StructType\JP_BookingCode $bookingCode = null, \StructType\JP_CruiseRequiredFields $cruiseRequiredFields = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null, \StructType\JP_CruisePriceInformation $priceInformation = null, \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist = null, \StructType\JP_CruiseOptionalElements $optionalElements = null, $cruiseCode = null, $zone = null, $startDate = null, $daysDuration = null, $ratePlanCode = null, $status = null)
    {
        $this
            ->setSea($sea)
            ->setName($name)
            ->setShip($ship)
            ->setItinerary($itinerary)
            ->setDescription($description)
            ->setCategories($categories)
            ->setBookingCode($bookingCode)
            ->setCruiseRequiredFields($cruiseRequiredFields)
            ->setCancellationPolicy($cancellationPolicy)
            ->setCancellationPolicyCost($cancellationPolicyCost)
            ->setPriceInformation($priceInformation)
            ->setRelPaxesDist($relPaxesDist)
            ->setOptionalElements($optionalElements)
            ->setCruiseCode($cruiseCode)
            ->setZone($zone)
            ->setStartDate($startDate)
            ->setDaysDuration($daysDuration)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status);
    }
    /**
     * Get Sea value
     * @return string|null
     */
    public function getSea()
    {
        return $this->Sea;
    }
    /**
     * Set Sea value
     * @param string $sea
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setSea($sea = null)
    {
        // validation for constraint: string
        if (!is_null($sea) && !is_string($sea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sea, true), gettype($sea)), __LINE__);
        }
        $this->Sea = $sea;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Ship value
     * @return \StructType\JP_Ship|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \StructType\JP_Ship $ship
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setShip(\StructType\JP_Ship $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get Itinerary value
     * @return \StructType\JP_CruiseItinerary|null
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @param \StructType\JP_CruiseItinerary $itinerary
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setItinerary(\StructType\JP_CruiseItinerary $itinerary = null)
    {
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Categories value
     * @return \ArrayType\ArrayOfJP_CruiseCategory|null
     */
    public function getCategories()
    {
        return $this->Categories;
    }
    /**
     * Set Categories value
     * @param \ArrayType\ArrayOfJP_CruiseCategory $categories
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setCategories(\ArrayType\ArrayOfJP_CruiseCategory $categories = null)
    {
        $this->Categories = $categories;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param \StructType\JP_BookingCode $bookingCode
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setBookingCode(\StructType\JP_BookingCode $bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get CruiseRequiredFields value
     * @return \StructType\JP_CruiseRequiredFields|null
     */
    public function getCruiseRequiredFields()
    {
        return $this->CruiseRequiredFields;
    }
    /**
     * Set CruiseRequiredFields value
     * @param \StructType\JP_CruiseRequiredFields $cruiseRequiredFields
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setCruiseRequiredFields(\StructType\JP_CruiseRequiredFields $cruiseRequiredFields = null)
    {
        $this->CruiseRequiredFields = $cruiseRequiredFields;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get CancellationPolicyCost value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicyCost()
    {
        return $this->CancellationPolicyCost;
    }
    /**
     * Set CancellationPolicyCost value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setCancellationPolicyCost(\StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null)
    {
        $this->CancellationPolicyCost = $cancellationPolicyCost;
        return $this;
    }
    /**
     * Get PriceInformation value
     * @return \StructType\JP_CruisePriceInformation|null
     */
    public function getPriceInformation()
    {
        return $this->PriceInformation;
    }
    /**
     * Set PriceInformation value
     * @param \StructType\JP_CruisePriceInformation $priceInformation
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setPriceInformation(\StructType\JP_CruisePriceInformation $priceInformation = null)
    {
        $this->PriceInformation = $priceInformation;
        return $this;
    }
    /**
     * Get RelPaxesDist value
     * @return \ArrayType\ArrayOfJP_RelPaxDist|null
     */
    public function getRelPaxesDist()
    {
        return $this->RelPaxesDist;
    }
    /**
     * Set RelPaxesDist value
     * @param \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setRelPaxesDist(\ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist = null)
    {
        $this->RelPaxesDist = $relPaxesDist;
        return $this;
    }
    /**
     * Get OptionalElements value
     * @return \StructType\JP_CruiseOptionalElements|null
     */
    public function getOptionalElements()
    {
        return $this->OptionalElements;
    }
    /**
     * Set OptionalElements value
     * @param \StructType\JP_CruiseOptionalElements $optionalElements
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setOptionalElements(\StructType\JP_CruiseOptionalElements $optionalElements = null)
    {
        $this->OptionalElements = $optionalElements;
        return $this;
    }
    /**
     * Get CruiseCode value
     * @return string|null
     */
    public function getCruiseCode()
    {
        return $this->CruiseCode;
    }
    /**
     * Set CruiseCode value
     * @param string $cruiseCode
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setCruiseCode($cruiseCode = null)
    {
        // validation for constraint: string
        if (!is_null($cruiseCode) && !is_string($cruiseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cruiseCode, true), gettype($cruiseCode)), __LINE__);
        }
        $this->CruiseCode = $cruiseCode;
        return $this;
    }
    /**
     * Get Zone value
     * @return int|null
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !(is_int($zone) || ctype_digit($zone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zone, true), gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get DaysDuration value
     * @return int|null
     */
    public function getDaysDuration()
    {
        return $this->DaysDuration;
    }
    /**
     * Set DaysDuration value
     * @param int $daysDuration
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setDaysDuration($daysDuration = null)
    {
        // validation for constraint: int
        if (!is_null($daysDuration) && !(is_int($daysDuration) || ctype_digit($daysDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($daysDuration, true), gettype($daysDuration)), __LINE__);
        }
        $this->DaysDuration = $daysDuration;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseCheckAvailResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
