<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferBookingRules StructType
 * @subpackage Structs
 */
class JP_TransferBookingRules extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The BookingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $BookingCode;
    /**
     * The TransferRequiredFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferRequiredFields
     */
    public $TransferRequiredFields;
    /**
     * The CancellationPolicies
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CancellationPolicyRules
     */
    public $CancellationPolicies;
    /**
     * The PriceInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PriceInformationTransfer
     */
    public $PriceInformation;
    /**
     * The OriginZone
     * @var int
     */
    public $OriginZone;
    /**
     * The DestinationZone
     * @var int
     */
    public $DestinationZone;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_TransferBookingRules
     * @uses JP_TransferBookingRules::setStatus()
     * @uses JP_TransferBookingRules::setStart()
     * @uses JP_TransferBookingRules::setEnd()
     * @uses JP_TransferBookingRules::setBookingCode()
     * @uses JP_TransferBookingRules::setTransferRequiredFields()
     * @uses JP_TransferBookingRules::setCancellationPolicies()
     * @uses JP_TransferBookingRules::setPriceInformation()
     * @uses JP_TransferBookingRules::setOriginZone()
     * @uses JP_TransferBookingRules::setDestinationZone()
     * @uses JP_TransferBookingRules::setCode()
     * @param string $status
     * @param string $start
     * @param string $end
     * @param \StructType\JP_BookingCode $bookingCode
     * @param \StructType\JP_TransferRequiredFields $transferRequiredFields
     * @param \ArrayType\ArrayOfJP_CancellationPolicyRules $cancellationPolicies
     * @param \StructType\JP_PriceInformationTransfer $priceInformation
     * @param int $originZone
     * @param int $destinationZone
     * @param string $code
     */
    public function __construct($status = null, $start = null, $end = null, \StructType\JP_BookingCode $bookingCode = null, \StructType\JP_TransferRequiredFields $transferRequiredFields = null, \ArrayType\ArrayOfJP_CancellationPolicyRules $cancellationPolicies = null, \StructType\JP_PriceInformationTransfer $priceInformation = null, $originZone = null, $destinationZone = null, $code = null)
    {
        $this
            ->setStatus($status)
            ->setStart($start)
            ->setEnd($end)
            ->setBookingCode($bookingCode)
            ->setTransferRequiredFields($transferRequiredFields)
            ->setCancellationPolicies($cancellationPolicies)
            ->setPriceInformation($priceInformation)
            ->setOriginZone($originZone)
            ->setDestinationZone($destinationZone)
            ->setCode($code);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_TransferBookingRules
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_TransferBookingRules
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_TransferBookingRules
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param \StructType\JP_BookingCode $bookingCode
     * @return \StructType\JP_TransferBookingRules
     */
    public function setBookingCode(\StructType\JP_BookingCode $bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get TransferRequiredFields value
     * @return \StructType\JP_TransferRequiredFields|null
     */
    public function getTransferRequiredFields()
    {
        return $this->TransferRequiredFields;
    }
    /**
     * Set TransferRequiredFields value
     * @param \StructType\JP_TransferRequiredFields $transferRequiredFields
     * @return \StructType\JP_TransferBookingRules
     */
    public function setTransferRequiredFields(\StructType\JP_TransferRequiredFields $transferRequiredFields = null)
    {
        $this->TransferRequiredFields = $transferRequiredFields;
        return $this;
    }
    /**
     * Get CancellationPolicies value
     * @return \ArrayType\ArrayOfJP_CancellationPolicyRules|null
     */
    public function getCancellationPolicies()
    {
        return $this->CancellationPolicies;
    }
    /**
     * Set CancellationPolicies value
     * @param \ArrayType\ArrayOfJP_CancellationPolicyRules $cancellationPolicies
     * @return \StructType\JP_TransferBookingRules
     */
    public function setCancellationPolicies(\ArrayType\ArrayOfJP_CancellationPolicyRules $cancellationPolicies = null)
    {
        $this->CancellationPolicies = $cancellationPolicies;
        return $this;
    }
    /**
     * Get PriceInformation value
     * @return \StructType\JP_PriceInformationTransfer|null
     */
    public function getPriceInformation()
    {
        return $this->PriceInformation;
    }
    /**
     * Set PriceInformation value
     * @param \StructType\JP_PriceInformationTransfer $priceInformation
     * @return \StructType\JP_TransferBookingRules
     */
    public function setPriceInformation(\StructType\JP_PriceInformationTransfer $priceInformation = null)
    {
        $this->PriceInformation = $priceInformation;
        return $this;
    }
    /**
     * Get OriginZone value
     * @return int|null
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param int $originZone
     * @return \StructType\JP_TransferBookingRules
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: int
        if (!is_null($originZone) && !(is_int($originZone) || ctype_digit($originZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originZone, true), gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_TransferBookingRules
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !(is_int($destinationZone) || ctype_digit($destinationZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_TransferBookingRules
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_TransferBookingRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
