<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Route StructType
 * @subpackage Structs
 */
class JP_Route extends AbstractStructBase
{
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Destination;
    /**
     * The Segments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_FlightSegment
     */
    public $Segments;
    /**
     * The OriginIATA
     * @var string
     */
    public $OriginIATA;
    /**
     * The DestinationIATA
     * @var string
     */
    public $DestinationIATA;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * Constructor method for JP_Route
     * @uses JP_Route::setOrigin()
     * @uses JP_Route::setDestination()
     * @uses JP_Route::setSegments()
     * @uses JP_Route::setOriginIATA()
     * @uses JP_Route::setDestinationIATA()
     * @uses JP_Route::setDate()
     * @param int $origin
     * @param int $destination
     * @param \ArrayType\ArrayOfJP_FlightSegment $segments
     * @param string $originIATA
     * @param string $destinationIATA
     * @param string $date
     */
    public function __construct($origin = null, $destination = null, \ArrayType\ArrayOfJP_FlightSegment $segments = null, $originIATA = null, $destinationIATA = null, $date = null)
    {
        $this
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setSegments($segments)
            ->setOriginIATA($originIATA)
            ->setDestinationIATA($destinationIATA)
            ->setDate($date);
    }
    /**
     * Get Origin value
     * @return int
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param int $origin
     * @return \StructType\JP_Route
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: int
        if (!is_null($origin) && !(is_int($origin) || ctype_digit($origin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return int
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param int $destination
     * @return \StructType\JP_Route
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: int
        if (!is_null($destination) && !(is_int($destination) || ctype_digit($destination))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get Segments value
     * @return \ArrayType\ArrayOfJP_FlightSegment|null
     */
    public function getSegments()
    {
        return $this->Segments;
    }
    /**
     * Set Segments value
     * @param \ArrayType\ArrayOfJP_FlightSegment $segments
     * @return \StructType\JP_Route
     */
    public function setSegments(\ArrayType\ArrayOfJP_FlightSegment $segments = null)
    {
        $this->Segments = $segments;
        return $this;
    }
    /**
     * Get OriginIATA value
     * @return string|null
     */
    public function getOriginIATA()
    {
        return $this->OriginIATA;
    }
    /**
     * Set OriginIATA value
     * @param string $originIATA
     * @return \StructType\JP_Route
     */
    public function setOriginIATA($originIATA = null)
    {
        // validation for constraint: string
        if (!is_null($originIATA) && !is_string($originIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originIATA, true), gettype($originIATA)), __LINE__);
        }
        $this->OriginIATA = $originIATA;
        return $this;
    }
    /**
     * Get DestinationIATA value
     * @return string|null
     */
    public function getDestinationIATA()
    {
        return $this->DestinationIATA;
    }
    /**
     * Set DestinationIATA value
     * @param string $destinationIATA
     * @return \StructType\JP_Route
     */
    public function setDestinationIATA($destinationIATA = null)
    {
        // validation for constraint: string
        if (!is_null($destinationIATA) && !is_string($destinationIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationIATA, true), gettype($destinationIATA)), __LINE__);
        }
        $this->DestinationIATA = $destinationIATA;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\JP_Route
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Route
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
