<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Payment StructType
 * @subpackage Structs
 */
class JP_Payment extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PaymentPrice
     */
    public $Price;
    /**
     * The CreditCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CreditCardInfo
     */
    public $CreditCard;
    /**
     * The Installments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Installments;
    /**
     * The AlternateReceiptCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AlternateReceiptCode;
    /**
     * The ExternalPaymentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalPaymentReference;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The PaymentType
     * @var string
     */
    public $PaymentType;
    /**
     * Constructor method for JP_Payment
     * @uses JP_Payment::setPrice()
     * @uses JP_Payment::setCreditCard()
     * @uses JP_Payment::setInstallments()
     * @uses JP_Payment::setAlternateReceiptCode()
     * @uses JP_Payment::setExternalPaymentReference()
     * @uses JP_Payment::setAction()
     * @uses JP_Payment::setPaymentType()
     * @param \StructType\JP_PaymentPrice $price
     * @param \StructType\JP_CreditCardInfo $creditCard
     * @param int $installments
     * @param int $alternateReceiptCode
     * @param string $externalPaymentReference
     * @param string $action
     * @param string $paymentType
     */
    public function __construct(\StructType\JP_PaymentPrice $price = null, \StructType\JP_CreditCardInfo $creditCard = null, $installments = null, $alternateReceiptCode = null, $externalPaymentReference = null, $action = null, $paymentType = null)
    {
        $this
            ->setPrice($price)
            ->setCreditCard($creditCard)
            ->setInstallments($installments)
            ->setAlternateReceiptCode($alternateReceiptCode)
            ->setExternalPaymentReference($externalPaymentReference)
            ->setAction($action)
            ->setPaymentType($paymentType);
    }
    /**
     * Get Price value
     * @return \StructType\JP_PaymentPrice|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\JP_PaymentPrice $price
     * @return \StructType\JP_Payment
     */
    public function setPrice(\StructType\JP_PaymentPrice $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get CreditCard value
     * @return \StructType\JP_CreditCardInfo|null
     */
    public function getCreditCard()
    {
        return $this->CreditCard;
    }
    /**
     * Set CreditCard value
     * @param \StructType\JP_CreditCardInfo $creditCard
     * @return \StructType\JP_Payment
     */
    public function setCreditCard(\StructType\JP_CreditCardInfo $creditCard = null)
    {
        $this->CreditCard = $creditCard;
        return $this;
    }
    /**
     * Get Installments value
     * @return int|null
     */
    public function getInstallments()
    {
        return $this->Installments;
    }
    /**
     * Set Installments value
     * @param int $installments
     * @return \StructType\JP_Payment
     */
    public function setInstallments($installments = null)
    {
        // validation for constraint: int
        if (!is_null($installments) && !(is_int($installments) || ctype_digit($installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($installments, true), gettype($installments)), __LINE__);
        }
        $this->Installments = $installments;
        return $this;
    }
    /**
     * Get AlternateReceiptCode value
     * @return int|null
     */
    public function getAlternateReceiptCode()
    {
        return $this->AlternateReceiptCode;
    }
    /**
     * Set AlternateReceiptCode value
     * @param int $alternateReceiptCode
     * @return \StructType\JP_Payment
     */
    public function setAlternateReceiptCode($alternateReceiptCode = null)
    {
        // validation for constraint: int
        if (!is_null($alternateReceiptCode) && !(is_int($alternateReceiptCode) || ctype_digit($alternateReceiptCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alternateReceiptCode, true), gettype($alternateReceiptCode)), __LINE__);
        }
        $this->AlternateReceiptCode = $alternateReceiptCode;
        return $this;
    }
    /**
     * Get ExternalPaymentReference value
     * @return string|null
     */
    public function getExternalPaymentReference()
    {
        return $this->ExternalPaymentReference;
    }
    /**
     * Set ExternalPaymentReference value
     * @param string $externalPaymentReference
     * @return \StructType\JP_Payment
     */
    public function setExternalPaymentReference($externalPaymentReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalPaymentReference) && !is_string($externalPaymentReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalPaymentReference, true), gettype($externalPaymentReference)), __LINE__);
        }
        $this->ExternalPaymentReference = $externalPaymentReference;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\Action::valueIsValid()
     * @uses \EnumType\Action::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\JP_Payment
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Action::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Action', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \EnumType\Action::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\JP_Payment
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
