<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Note StructType
 * @subpackage Structs
 */
class Note extends AbstractStructBase
{
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_MultiLanguageText[]
     */
    public $Text;
    /**
     * The From
     * @var string
     */
    public $From;
    /**
     * The To
     * @var string
     */
    public $To;
    /**
     * Constructor method for Note
     * @uses Note::setText()
     * @uses Note::setFrom()
     * @uses Note::setTo()
     * @param \StructType\JP_MultiLanguageText[] $text
     * @param string $from
     * @param string $to
     */
    public function __construct(array $text = array(), $from = null, $to = null)
    {
        $this
            ->setText($text)
            ->setFrom($from)
            ->setTo($to);
    }
    /**
     * Get Text value
     * @return \StructType\JP_MultiLanguageText[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * This method is responsible for validating the values passed to the setText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextForArrayConstraintsFromSetText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $noteTextItem) {
            // validation for constraint: itemType
            if (!$noteTextItem instanceof \StructType\JP_MultiLanguageText) {
                $invalidValues[] = is_object($noteTextItem) ? get_class($noteTextItem) : sprintf('%s(%s)', gettype($noteTextItem), var_export($noteTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Text property can only contain items of type \StructType\JP_MultiLanguageText, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_MultiLanguageText[] $text
     * @return \StructType\Note
     */
    public function setText(array $text = array())
    {
        // validation for constraint: array
        if ('' !== ($textArrayErrorMessage = self::validateTextForArrayConstraintsFromSetText($text))) {
            throw new \InvalidArgumentException($textArrayErrorMessage, __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_MultiLanguageText $item
     * @return \StructType\Note
     */
    public function addToText(\StructType\JP_MultiLanguageText $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_MultiLanguageText) {
            throw new \InvalidArgumentException(sprintf('The Text property can only contain items of type \StructType\JP_MultiLanguageText, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\Note
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \StructType\Note
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Note
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
