<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceBookingInfo StructType
 * @subpackage Structs
 */
class JP_ServiceBookingInfo extends AbstractStructBase
{
    /**
     * The MeetingPointInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_MeetingPointInfo
     */
    public $MeetingPointInfo;
    /**
     * The SupplementsInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_SupplementsInfo
     */
    public $SupplementsInfo;
    /**
     * The GroundHandlingComments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroundHandlingComments;
    /**
     * The HotelService
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelService
     */
    public $HotelService;
    /**
     * The FlightInfoOrigin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_FlightInfoService
     */
    public $FlightInfoOrigin;
    /**
     * The FlightInfoDestination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_FlightInfoService
     */
    public $FlightInfoDestination;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Language
     */
    public $Language;
    /**
     * The ICode
     * @var string
     */
    public $ICode;
    /**
     * Constructor method for JP_ServiceBookingInfo
     * @uses JP_ServiceBookingInfo::setMeetingPointInfo()
     * @uses JP_ServiceBookingInfo::setSupplementsInfo()
     * @uses JP_ServiceBookingInfo::setGroundHandlingComments()
     * @uses JP_ServiceBookingInfo::setHotelService()
     * @uses JP_ServiceBookingInfo::setFlightInfoOrigin()
     * @uses JP_ServiceBookingInfo::setFlightInfoDestination()
     * @uses JP_ServiceBookingInfo::setLanguage()
     * @uses JP_ServiceBookingInfo::setICode()
     * @param \StructType\JP_MeetingPointInfo $meetingPointInfo
     * @param \StructType\JP_SupplementsInfo $supplementsInfo
     * @param string $groundHandlingComments
     * @param \StructType\JP_HotelService $hotelService
     * @param \StructType\JP_FlightInfoService $flightInfoOrigin
     * @param \StructType\JP_FlightInfoService $flightInfoDestination
     * @param \StructType\JP_Language $language
     * @param string $iCode
     */
    public function __construct(\StructType\JP_MeetingPointInfo $meetingPointInfo = null, \StructType\JP_SupplementsInfo $supplementsInfo = null, $groundHandlingComments = null, \StructType\JP_HotelService $hotelService = null, \StructType\JP_FlightInfoService $flightInfoOrigin = null, \StructType\JP_FlightInfoService $flightInfoDestination = null, \StructType\JP_Language $language = null, $iCode = null)
    {
        $this
            ->setMeetingPointInfo($meetingPointInfo)
            ->setSupplementsInfo($supplementsInfo)
            ->setGroundHandlingComments($groundHandlingComments)
            ->setHotelService($hotelService)
            ->setFlightInfoOrigin($flightInfoOrigin)
            ->setFlightInfoDestination($flightInfoDestination)
            ->setLanguage($language)
            ->setICode($iCode);
    }
    /**
     * Get MeetingPointInfo value
     * @return \StructType\JP_MeetingPointInfo|null
     */
    public function getMeetingPointInfo()
    {
        return $this->MeetingPointInfo;
    }
    /**
     * Set MeetingPointInfo value
     * @param \StructType\JP_MeetingPointInfo $meetingPointInfo
     * @return \StructType\JP_ServiceBookingInfo
     */
    public function setMeetingPointInfo(\StructType\JP_MeetingPointInfo $meetingPointInfo = null)
    {
        $this->MeetingPointInfo = $meetingPointInfo;
        return $this;
    }
    /**
     * Get SupplementsInfo value
     * @return \StructType\JP_SupplementsInfo|null
     */
    public function getSupplementsInfo()
    {
        return $this->SupplementsInfo;
    }
    /**
     * Set SupplementsInfo value
     * @param \StructType\JP_SupplementsInfo $supplementsInfo
     * @return \StructType\JP_ServiceBookingInfo
     */
    public function setSupplementsInfo(\StructType\JP_SupplementsInfo $supplementsInfo = null)
    {
        $this->SupplementsInfo = $supplementsInfo;
        return $this;
    }
    /**
     * Get GroundHandlingComments value
     * @return string|null
     */
    public function getGroundHandlingComments()
    {
        return $this->GroundHandlingComments;
    }
    /**
     * Set GroundHandlingComments value
     * @param string $groundHandlingComments
     * @return \StructType\JP_ServiceBookingInfo
     */
    public function setGroundHandlingComments($groundHandlingComments = null)
    {
        // validation for constraint: string
        if (!is_null($groundHandlingComments) && !is_string($groundHandlingComments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groundHandlingComments, true), gettype($groundHandlingComments)), __LINE__);
        }
        $this->GroundHandlingComments = $groundHandlingComments;
        return $this;
    }
    /**
     * Get HotelService value
     * @return \StructType\JP_HotelService|null
     */
    public function getHotelService()
    {
        return $this->HotelService;
    }
    /**
     * Set HotelService value
     * @param \StructType\JP_HotelService $hotelService
     * @return \StructType\JP_ServiceBookingInfo
     */
    public function setHotelService(\StructType\JP_HotelService $hotelService = null)
    {
        $this->HotelService = $hotelService;
        return $this;
    }
    /**
     * Get FlightInfoOrigin value
     * @return \StructType\JP_FlightInfoService|null
     */
    public function getFlightInfoOrigin()
    {
        return $this->FlightInfoOrigin;
    }
    /**
     * Set FlightInfoOrigin value
     * @param \StructType\JP_FlightInfoService $flightInfoOrigin
     * @return \StructType\JP_ServiceBookingInfo
     */
    public function setFlightInfoOrigin(\StructType\JP_FlightInfoService $flightInfoOrigin = null)
    {
        $this->FlightInfoOrigin = $flightInfoOrigin;
        return $this;
    }
    /**
     * Get FlightInfoDestination value
     * @return \StructType\JP_FlightInfoService|null
     */
    public function getFlightInfoDestination()
    {
        return $this->FlightInfoDestination;
    }
    /**
     * Set FlightInfoDestination value
     * @param \StructType\JP_FlightInfoService $flightInfoDestination
     * @return \StructType\JP_ServiceBookingInfo
     */
    public function setFlightInfoDestination(\StructType\JP_FlightInfoService $flightInfoDestination = null)
    {
        $this->FlightInfoDestination = $flightInfoDestination;
        return $this;
    }
    /**
     * Get Language value
     * @return \StructType\JP_Language|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param \StructType\JP_Language $language
     * @return \StructType\JP_ServiceBookingInfo
     */
    public function setLanguage(\StructType\JP_Language $language = null)
    {
        $this->Language = $language;
        return $this;
    }
    /**
     * Get ICode value
     * @return string|null
     */
    public function getICode()
    {
        return $this->ICode;
    }
    /**
     * Set ICode value
     * @param string $iCode
     * @return \StructType\JP_ServiceBookingInfo
     */
    public function setICode($iCode = null)
    {
        // validation for constraint: string
        if (!is_null($iCode) && !is_string($iCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iCode, true), gettype($iCode)), __LINE__);
        }
        $this->ICode = $iCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceBookingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
