<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferContentInfo StructType
 * @subpackage Structs
 */
class JP_TransferContentInfo extends AbstractStructBase
{
    /**
     * The TransferName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransferName;
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Description
     */
    public $Descriptions;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ImageLong
     */
    public $Images;
    /**
     * Constructor method for JP_TransferContentInfo
     * @uses JP_TransferContentInfo::setTransferName()
     * @uses JP_TransferContentInfo::setDescriptions()
     * @uses JP_TransferContentInfo::setImages()
     * @param string $transferName
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     */
    public function __construct($transferName = null, \ArrayType\ArrayOfJP_Description $descriptions = null, \ArrayType\ArrayOfJP_ImageLong $images = null)
    {
        $this
            ->setTransferName($transferName)
            ->setDescriptions($descriptions)
            ->setImages($images);
    }
    /**
     * Get TransferName value
     * @return string|null
     */
    public function getTransferName()
    {
        return $this->TransferName;
    }
    /**
     * Set TransferName value
     * @param string $transferName
     * @return \StructType\JP_TransferContentInfo
     */
    public function setTransferName($transferName = null)
    {
        // validation for constraint: string
        if (!is_null($transferName) && !is_string($transferName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferName, true), gettype($transferName)), __LINE__);
        }
        $this->TransferName = $transferName;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \ArrayType\ArrayOfJP_Description|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @return \StructType\JP_TransferContentInfo
     */
    public function setDescriptions(\ArrayType\ArrayOfJP_Description $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfJP_ImageLong|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @return \StructType\JP_TransferContentInfo
     */
    public function setImages(\ArrayType\ArrayOfJP_ImageLong $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_TransferContentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
