<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentTransfers StructType
 * @subpackage Structs
 */
class JP_SearchSegmentTransfers extends JP_SearchSegmentBase
{
    /**
     * The Suppliers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Suppliers
     */
    public $Suppliers;
    /**
     * The Hour
     * @var string
     */
    public $Hour;
    /**
     * The HourEnd
     * @var string
     */
    public $HourEnd;
    /**
     * The Type
     * @var int
     */
    public $Type;
    /**
     * The InternalSupplier
     * @var int
     */
    public $InternalSupplier;
    /**
     * The Route
     * @var string
     */
    public $Route;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The OptionCode
     * @var string
     */
    public $OptionCode;
    /**
     * Constructor method for JP_SearchSegmentTransfers
     * @uses JP_SearchSegmentTransfers::setSuppliers()
     * @uses JP_SearchSegmentTransfers::setHour()
     * @uses JP_SearchSegmentTransfers::setHourEnd()
     * @uses JP_SearchSegmentTransfers::setType()
     * @uses JP_SearchSegmentTransfers::setInternalSupplier()
     * @uses JP_SearchSegmentTransfers::setRoute()
     * @uses JP_SearchSegmentTransfers::setCode()
     * @uses JP_SearchSegmentTransfers::setOptionCode()
     * @param \StructType\JP_Suppliers $suppliers
     * @param string $hour
     * @param string $hourEnd
     * @param int $type
     * @param int $internalSupplier
     * @param string $route
     * @param string $code
     * @param string $optionCode
     */
    public function __construct(\StructType\JP_Suppliers $suppliers = null, $hour = null, $hourEnd = null, $type = null, $internalSupplier = null, $route = null, $code = null, $optionCode = null)
    {
        $this
            ->setSuppliers($suppliers)
            ->setHour($hour)
            ->setHourEnd($hourEnd)
            ->setType($type)
            ->setInternalSupplier($internalSupplier)
            ->setRoute($route)
            ->setCode($code)
            ->setOptionCode($optionCode);
    }
    /**
     * Get Suppliers value
     * @return \StructType\JP_Suppliers|null
     */
    public function getSuppliers()
    {
        return $this->Suppliers;
    }
    /**
     * Set Suppliers value
     * @param \StructType\JP_Suppliers $suppliers
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setSuppliers(\StructType\JP_Suppliers $suppliers = null)
    {
        $this->Suppliers = $suppliers;
        return $this;
    }
    /**
     * Get Hour value
     * @return string|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param string $hour
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setHour($hour = null)
    {
        // validation for constraint: string
        if (!is_null($hour) && !is_string($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hour, true), gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get HourEnd value
     * @return string|null
     */
    public function getHourEnd()
    {
        return $this->HourEnd;
    }
    /**
     * Set HourEnd value
     * @param string $hourEnd
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setHourEnd($hourEnd = null)
    {
        // validation for constraint: string
        if (!is_null($hourEnd) && !is_string($hourEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hourEnd, true), gettype($hourEnd)), __LINE__);
        }
        $this->HourEnd = $hourEnd;
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get InternalSupplier value
     * @return int|null
     */
    public function getInternalSupplier()
    {
        return $this->InternalSupplier;
    }
    /**
     * Set InternalSupplier value
     * @param int $internalSupplier
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setInternalSupplier($internalSupplier = null)
    {
        // validation for constraint: int
        if (!is_null($internalSupplier) && !(is_int($internalSupplier) || ctype_digit($internalSupplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internalSupplier, true), gettype($internalSupplier)), __LINE__);
        }
        $this->InternalSupplier = $internalSupplier;
        return $this;
    }
    /**
     * Get Route value
     * @return string|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @uses \EnumType\JP_RouteType::valueIsValid()
     * @uses \EnumType\JP_RouteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $route
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setRoute($route = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_RouteType::valueIsValid($route)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_RouteType', is_array($route) ? implode(', ', $route) : var_export($route, true), implode(', ', \EnumType\JP_RouteType::getValidValues())), __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get OptionCode value
     * @return string|null
     */
    public function getOptionCode()
    {
        return $this->OptionCode;
    }
    /**
     * Set OptionCode value
     * @param string $optionCode
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public function setOptionCode($optionCode = null)
    {
        // validation for constraint: string
        if (!is_null($optionCode) && !is_string($optionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionCode, true), gettype($optionCode)), __LINE__);
        }
        $this->OptionCode = $optionCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_SearchSegmentTransfers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
